/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient.api;

import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.CISInfoProvider;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import pl.edu.icm.unicore.uvos.wsclient.api.UVOSGLUEExtInterface;
import xmlbeans.pl.edu.icm.uvos.cisprovider.GetServiceInfoRequestDocument;
import xmlbeans.pl.edu.icm.uvos.cisprovider.GetServiceInfoResponseDocument;
import xmlbeans.pl.edu.icm.uvos.glue2.EndpointT;
import xmlbeans.pl.edu.icm.uvos.glue2.ServiceT;

public class WSGLUEClient
implements UVOSGLUEExtInterface {
    private CISInfoProvider proxy;

    public WSGLUEClient(CISInfoProvider proxy) {
        this.proxy = proxy;
    }

    private EndpointT getFirstEndpoint() throws UVOSException {
        ServiceT service = this.getServicesInformation()[0];
        EndpointT[] endpoints = service.getEndpointArray();
        if (endpoints == null || endpoints.length == 0) {
            throw new UVOSException("Got empty information about service's endpoints, protocol failure.");
        }
        return endpoints[0];
    }

    @Override
    public String getServerVersion() throws UVOSException {
        return this.getFirstEndpoint().getImplementationVersion();
    }

    @Override
    public String getServerDistribution() throws UVOSException {
        EndpointT endpoint = this.getFirstEndpoint();
        String[] others = endpoint.getOtherInfoArray();
        if (others == null || others.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String other : others) {
            if (other.startsWith("MiddlewareName=")) {
                sb.append(other.replace("=", ": ")).append("\n");
            }
            if (!other.startsWith("MiddlewareVersion=")) continue;
            sb.append(other.replace("=", ": ")).append("\n");
        }
        return sb.toString().trim();
    }

    @Override
    public String getServerDescription() throws UVOSException {
        ServiceT service = this.getServicesInformation()[0];
        if (service.getEndpointArray() == null || service.getEndpointArray().length == 0) {
            throw new UVOSException("Got empty information about service's endpoints, protocol failure.");
        }
        EndpointT endpoint = service.getEndpointArray(0);
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ");
        sb.append(service.getName());
        sb.append("\nVersion: ");
        sb.append(endpoint.getImplementationVersion());
        String distro = this.getServerDistribution();
        if (distro.length() > 0) {
            sb.append("\n").append(distro);
        }
        return sb.toString();
    }

    @Override
    public ServiceT[] getServicesInformation() throws UVOSException {
        GetServiceInfoResponseDocument serviceInfoDoc = this.getServiceInfo();
        ServiceT[] services = serviceInfoDoc.getGetServiceInfoResponse().getServiceArray();
        if (services == null || services.length == 0) {
            throw new UVOSException("Got empty information about services, protocol failure.");
        }
        return services;
    }

    @Override
    public GetServiceInfoResponseDocument getServiceInfo() throws UVOSException {
        GetServiceInfoRequestDocument reqDoc = GetServiceInfoRequestDocument.Factory.newInstance();
        reqDoc.addNewGetServiceInfoRequest();
        try {
            return this.proxy.getServiceInfo(reqDoc);
        }
        catch (UVOSFault e) {
            throw e.getAsAPIException();
        }
    }
}

