/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.io.File;
import pl.edu.icm.unicore.uvos.api.VOApplicationForm;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.XMLBeansMapper;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormDocument;

class SetApplicationFormAction
extends AbstractAction {
    SetApplicationFormAction(ConnectionManager cm) {
        super(cm, "setApplicationForm", "Adds or updates application form. Definition is read form XML file\nSyntax:\n   setApplicationForm <update:true|false> \t<fileWithDefinition>\nExample:\n   setApplicationForm true appForm3.xml", 2);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        VOApplicationFormDocument formDoc;
        boolean update = false;
        if (args[1].equals("true")) {
            update = true;
        }
        try {
            formDoc = VOApplicationFormDocument.Factory.parse((File)new File(args[2]));
        }
        catch (Exception e) {
            throw new InternalException("Can't parse the file " + args[2] + ": " + e);
        }
        VOApplicationForm appDef = XMLBeansMapper.map2APIVOApplicationForm((VOApplicationFormDocument)formDoc);
        this.cm.voApps.updateApplicationForm(appDef, update);
        if (!update) {
            System.out.println("Added a new application form with name " + appDef.getFriendlyName());
        } else {
            System.out.println("Updated application form with id " + appDef.getId());
        }
        return true;
    }
}

