/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import pl.edu.icm.unicore.uvos.api.ModificationEvent;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class GetEventsAction
extends AbstractAction {
    GetEventsAction(ConnectionManager cm) {
        super(cm, "getEvents", "Displays all events (i.e. contents modification) which occured in the specified period of time. Syntax:\n  getEvents [from <yyyy-mm-dd> <hh:mm:ss>] [to <yyyy-mm-dd> <hh:mm:ss>]\nIf any of range bounds is not specified then it is unlimited.\nExample:\n  getEvents from 2007-03-28 21:49:00\nIt will display all events from the specified date till now.", 0);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Date from = null;
        Date to = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            if (args.length > 3) {
                if (args[1].equals("from")) {
                    from = format.parse(args[2] + "T" + args[3]);
                } else {
                    to = format.parse(args[2] + "T" + args[3]);
                }
            }
            if (args.length > 6) {
                if (args[4].equals("from")) {
                    from = format.parse(args[5] + "T" + args[6]);
                } else {
                    to = format.parse(args[5] + "T" + args[6]);
                }
            }
        }
        catch (ParseException e) {
            System.out.println("Can't parse date and time: " + e.getMessage());
            return true;
        }
        int f1 = 1 << ModificationEvent.CATEGORY.ATTRIBUTE.ordinal() | 1 << ModificationEvent.CATEGORY.ENTITY.ordinal() | 1 << ModificationEvent.CATEGORY.GROUP.ordinal() | 1 << ModificationEvent.CATEGORY.IDENTITY.ordinal() | 1 << ModificationEvent.CATEGORY.MEMBERSHIP.ordinal();
        int f2 = 1 << ModificationEvent.TYPE.ADD.ordinal() | 1 << ModificationEvent.TYPE.REMOVE.ordinal();
        List<ModificationEvent> ret = this.cm.voQueryHistory.getHistoryEvents(from, to, f1, f2, true);
        System.out.println("Received events:\n");
        for (ModificationEvent me : ret) {
            System.out.println("Timestamp: " + me.getTimestamp());
            System.out.println("Category: " + me.getCategory());
            System.out.println("Type: " + me.getType());
            System.out.println("Details: " + me.getDescription());
            System.out.println("--------------------------------");
        }
        return true;
    }
}

