/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class DisableAttributeAction
extends AbstractAction {
    DisableAttributeAction(ConnectionManager cm) {
        super(cm, "disableAttribute", "Disables an attribute. Syntax:\n  disableAttribute <global> <dn|x509|email> <identity> <AttributeName> [value]\n  disableAttribute <group> <groupPath> <AttributeName> [value]\n  disableAttribute <ig> <dn|x509|email> <identity> <groupPath><AttributeName> [value]\nThe first argument specifies what kind of attribute will be changed: group attribute, identity global attribute, or identity attribute valid only in particular group. If the optional 'value' argument is set then only this value of attribute will be disabled.\nExample:\n  disableAttribute ig email ann@example.com /group urn:unicore:attrType:user:proffession scientist\n", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Element e = this.getElement(args, 1, args.length);
        if (e == null) {
            return true;
        }
        int next = 3;
        if (e.getIdentity() != null) {
            ++next;
            if (e.getGroup() != null) {
                ++next;
            }
        }
        if (next >= args.length) {
            System.out.println("Not enough arguments.");
            return true;
        }
        String attr = args[next];
        String value = null;
        if (next + 1 < args.length) {
            value = args[next + 1];
        }
        this.cm.voMan.disableAttribute(e, attr, value);
        if (value == null) {
            System.out.println("Disabled attribute " + attr + " of element " + e);
        } else {
            System.out.println("Disabled value " + value + " of attribute " + attr + " of element " + e);
        }
        return true;
    }
}

