/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import jline.Completor;
import jline.ConsoleReader;
import jline.SimpleCompletor;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.AddGroupAction;
import pl.edu.icm.unicore.uvos.clc.AddIdentityAction;
import pl.edu.icm.unicore.uvos.clc.AddIdentityWithEquivAction;
import pl.edu.icm.unicore.uvos.clc.AddNotificationAction;
import pl.edu.icm.unicore.uvos.clc.AddToGroupAction;
import pl.edu.icm.unicore.uvos.clc.AreEquivalentAction;
import pl.edu.icm.unicore.uvos.clc.ChangePasswdAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;
import pl.edu.icm.unicore.uvos.clc.CopyGroupAction;
import pl.edu.icm.unicore.uvos.clc.DeleteATypeAction;
import pl.edu.icm.unicore.uvos.clc.DisableAttributeAction;
import pl.edu.icm.unicore.uvos.clc.EnableAttributeAction;
import pl.edu.icm.unicore.uvos.clc.GetAllAttributesAction;
import pl.edu.icm.unicore.uvos.clc.GetAllEquivalentsAction;
import pl.edu.icm.unicore.uvos.clc.GetAllGroupsAction;
import pl.edu.icm.unicore.uvos.clc.GetAllIdentitiesAction;
import pl.edu.icm.unicore.uvos.clc.GetApplicationAction;
import pl.edu.icm.unicore.uvos.clc.GetApplicationFormsAction;
import pl.edu.icm.unicore.uvos.clc.GetAttributeAction;
import pl.edu.icm.unicore.uvos.clc.GetAuthZAction;
import pl.edu.icm.unicore.uvos.clc.GetEventsAction;
import pl.edu.icm.unicore.uvos.clc.GetGlueInfoAction;
import pl.edu.icm.unicore.uvos.clc.GetGroupContentAction;
import pl.edu.icm.unicore.uvos.clc.GetMyIdentitiesAction;
import pl.edu.icm.unicore.uvos.clc.GetPermissionsAction;
import pl.edu.icm.unicore.uvos.clc.IsMemeberAction;
import pl.edu.icm.unicore.uvos.clc.ListATypesAction;
import pl.edu.icm.unicore.uvos.clc.ListApplicationsAction;
import pl.edu.icm.unicore.uvos.clc.ListDisabledAttributesAction;
import pl.edu.icm.unicore.uvos.clc.ListITypesAction;
import pl.edu.icm.unicore.uvos.clc.ListNotificationsAction;
import pl.edu.icm.unicore.uvos.clc.ProcessApplicationAction;
import pl.edu.icm.unicore.uvos.clc.PurgeAction;
import pl.edu.icm.unicore.uvos.clc.RemoveApplicationFormAction;
import pl.edu.icm.unicore.uvos.clc.RemoveAttributeAction;
import pl.edu.icm.unicore.uvos.clc.RemoveAuthZAction;
import pl.edu.icm.unicore.uvos.clc.RemoveFromGroupAction;
import pl.edu.icm.unicore.uvos.clc.RemoveGroupAction;
import pl.edu.icm.unicore.uvos.clc.RemoveIdentityAction;
import pl.edu.icm.unicore.uvos.clc.RemoveNotificationAction;
import pl.edu.icm.unicore.uvos.clc.SetApplicationFormAction;
import pl.edu.icm.unicore.uvos.clc.SetAttributeAction;
import pl.edu.icm.unicore.uvos.clc.SetAuthZAction;
import pl.edu.icm.unicore.uvos.clc.SetIdentityStatusAction;
import pl.edu.icm.unicore.uvos.clc.SetLabelAction;
import pl.edu.icm.unicore.uvos.clc.SetTimeAction;
import pl.edu.icm.unicore.uvos.clc.SubmitApplicationAction;
import pl.edu.icm.unicore.uvos.clc.UpdateATypeAction;
import pl.edu.icm.unicore.uvos.clc.UpdateCSRApplicationAction;
import pl.edu.icm.unicore.uvos.client.util.UVOSClientProperties;
import pl.edu.icm.unicore.uvos.wsclient.api.UVOSClientFactory;

public class CLCExecutor {
    public static final String DEF_CONFIG = "conf/uvosClient.conf";
    public static final String CONFIG_LOC_ENV = "UVOSCLC_CONFIG";
    private HashMap<String, AbstractAction> actions;
    private String commandLine = null;
    private String[] parsedLine = null;
    private UVOSClientProperties conf;
    private String configFile = null;
    private ConnectionManager connManager;
    private boolean interactive = false;

    public CLCExecutor() {
    }

    public CLCExecutor(ConnectionManager m) {
        this.connManager = m;
    }

    public void commandLoop() {
        ConsoleReader in;
        try {
            in = new ConsoleReader();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        this.initReader(in);
        System.out.println("\nThis is a command line client which operates on UNICORE VO system.\n  Type 'help' to get started.\n");
        boolean end = false;
        do {
            try {
                String cmdLine = in.readLine();
                end = !this.invokeInteractiveCommand(cmdLine);
            }
            catch (IOException e) {
                end = true;
                e.printStackTrace();
            }
            catch (UVOSException e) {
                System.err.println("ERROR OCCURED:");
                e.printStackTrace();
            }
            System.out.println();
        } while (!end);
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public String[] getParsedLine() {
        return this.parsedLine;
    }

    public void init() throws InternalException, IdentityNotKnownException, AuthenticationException, MalformedURLException {
        String addr = this.conf.getProtocol() + "://" + this.conf.getServerHost() + ":" + this.conf.getServerPort();
        UVOSClientFactory fact = new UVOSClientFactory((IClientConfiguration)this.conf);
        this.connManager = new ConnectionManager(fact.getWSManagementClientHL(addr), fact.getWSAuthZClientHL(addr), fact.getWSQueryClientHL(addr), fact.getWSQueryHistoryClientHL(addr), fact.getWSAppsClientHL(addr), fact.getWSGlueClientHL(addr), null);
        this.registerAllActions();
    }

    private void initReader(ConsoleReader reader) {
        Iterator<AbstractAction> it = this.actions.values().iterator();
        ArrayList<AbstractAction> list = new ArrayList<AbstractAction>();
        SimpleCompletor completor = new SimpleCompletor(new String[0]);
        while (it.hasNext()) {
            AbstractAction aa = it.next();
            completor.addCandidateString(aa.cmd);
            list.add(aa);
        }
        reader.addCompletor((Completor)completor);
        reader.setDefaultPrompt("> ");
        reader.setUseHistory(true);
        reader.setUsePagination(true);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean invokeInteractiveCommand(String cmdLine) throws UVOSException {
        String[] tokens = this.splitCmd(cmdLine);
        return this.parseLine(tokens);
    }

    public boolean parseLine(String[] tokens) throws UVOSException {
        if (tokens.length == 0 || tokens[0].equals("")) {
            return true;
        }
        String cmd = tokens[0];
        AbstractAction aa = this.actions.get(cmd);
        if (aa == null) {
            System.out.println("Command '" + cmd + "' not found." + " Type 'help' to get started.");
            return true;
        }
        if (tokens.length - 1 < aa.getMinArgsNumber()) {
            System.out.println("There must be at least " + aa.getMinArgsNumber() + " arguments to the '" + aa.getName() + "' command.");
            return true;
        }
        return aa.invoke(tokens);
    }

    private void printCLHelp() {
        System.out.println("This is a command line client which operates on a UNICORE VO system.\nIt can be used in both interactive and batch mode.\nThe basic syntax is:\n   uvoscmd.??? [-c <configFile>] <-i|-b COMMAND ...>\nOptions are:\n     -i   Enter an intearactive mode.\n     -b   Use batch mode. COMMAND is one of the commands used in interactive mode.\n          Use 'help' command to see the list or 'help <CMD>' to get help on every command.\n\n     -c   Configuration file location.\nWithout options this help message is printed. Options order must be preserved.\n\nBy default the configuration file is read from the conf/uvosClient.conf file.\nThis can be changed by setting the UVOSCLC_CONFIG environment variable or by -c option.");
    }

    public boolean processCommandLineAgrs(String[] args) {
        if (args.length == 0) {
            this.printCLHelp();
            return false;
        }
        int nextOpt = 0;
        if (args[nextOpt].equals("-c")) {
            if (args.length < 3) {
                this.printCLHelp();
                return false;
            }
            nextOpt += 2;
            this.configFile = args[1];
        }
        if (args[nextOpt].equals("-i")) {
            this.interactive = true;
            return true;
        }
        if (args[nextOpt].equals("-b") && args.length > nextOpt) {
            this.parsedLine = new String[args.length - nextOpt - 1];
            int i = nextOpt + 1;
            int j = 0;
            while (i < args.length) {
                this.parsedLine[j] = args[i];
                ++i;
                ++j;
            }
            return true;
        }
        this.printCLHelp();
        return false;
    }

    public void readConfig() {
        this.conf = null;
        try {
            if (this.configFile == null) {
                this.configFile = System.getenv(CONFIG_LOC_ENV);
            }
            if (this.configFile == null) {
                this.configFile = DEF_CONFIG;
            }
            Properties p = FilePropertiesHelper.load((String)this.configFile);
            this.conf = new UVOSClientProperties(p);
        }
        catch (Exception e1) {
            System.out.println("Can't read configuration: " + e1);
            System.exit(1);
        }
    }

    private void registerAction(Class<? extends AbstractAction> aa) {
        String[] aliases;
        AbstractAction aaObj;
        try {
            Constructor<? extends AbstractAction> constructor = aa.getDeclaredConstructor(ConnectionManager.class);
            aaObj = constructor.newInstance(this.connManager);
        }
        catch (Exception e) {
            System.err.println("Buggy action: can't register action " + aa);
            e.printStackTrace();
            return;
        }
        this.actions.put(aaObj.getName(), aaObj);
        for (String alias : aliases = aaObj.getAliases()) {
            this.actions.put(alias, aaObj);
        }
    }

    public void registerAllActions() {
        this.actions = new HashMap();
        AbstractAction aaObj = new HelpAction(this.connManager);
        this.actions.put(aaObj.getName(), aaObj);
        aaObj = new HelpFullAction(this.connManager);
        this.actions.put(aaObj.getName(), aaObj);
        this.registerAction(ExitAction.class);
        this.registerAction(AddGroupAction.class);
        this.registerAction(RemoveGroupAction.class);
        this.registerAction(AddIdentityAction.class);
        this.registerAction(AddIdentityWithEquivAction.class);
        this.registerAction(RemoveIdentityAction.class);
        this.registerAction(AddToGroupAction.class);
        this.registerAction(RemoveFromGroupAction.class);
        this.registerAction(SetLabelAction.class);
        this.registerAction(CopyGroupAction.class);
        this.registerAction(SetAttributeAction.class);
        this.registerAction(RemoveAttributeAction.class);
        this.registerAction(DisableAttributeAction.class);
        this.registerAction(EnableAttributeAction.class);
        this.registerAction(ListDisabledAttributesAction.class);
        this.registerAction(ListATypesAction.class);
        this.registerAction(ListITypesAction.class);
        this.registerAction(PurgeAction.class);
        this.registerAction(IsMemeberAction.class);
        this.registerAction(GetGroupContentAction.class);
        this.registerAction(GetAllAttributesAction.class);
        this.registerAction(GetAttributeAction.class);
        this.registerAction(GetAllEquivalentsAction.class);
        this.registerAction(GetAllGroupsAction.class);
        this.registerAction(AreEquivalentAction.class);
        this.registerAction(GetAllIdentitiesAction.class);
        this.registerAction(RemoveAuthZAction.class);
        this.registerAction(SetAuthZAction.class);
        this.registerAction(GetAuthZAction.class);
        this.registerAction(GetPermissionsAction.class);
        this.registerAction(GetMyIdentitiesAction.class);
        this.registerAction(ChangePasswdAction.class);
        this.registerAction(DeleteATypeAction.class);
        this.registerAction(UpdateATypeAction.class);
        this.registerAction(SetTimeAction.class);
        this.registerAction(GetEventsAction.class);
        this.registerAction(SetApplicationFormAction.class);
        this.registerAction(GetApplicationFormsAction.class);
        this.registerAction(RemoveApplicationFormAction.class);
        this.registerAction(ListApplicationsAction.class);
        this.registerAction(ProcessApplicationAction.class);
        this.registerAction(UpdateCSRApplicationAction.class);
        this.registerAction(SubmitApplicationAction.class);
        this.registerAction(SetIdentityStatusAction.class);
        this.registerAction(ListNotificationsAction.class);
        this.registerAction(RemoveNotificationAction.class);
        this.registerAction(AddNotificationAction.class);
        this.registerAction(GetApplicationAction.class);
        this.registerAction(GetGlueInfoAction.class);
    }

    private String[] splitCmd(String line) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] c = line.toCharArray();
        int context = 32;
        StringBuffer curW = new StringBuffer();
        block7: for (int i = 0; i < c.length; ++i) {
            if (context != 45) {
                switch (context) {
                    case 32: {
                        if (c[i] == ' ') break;
                        if (c[i] == '\'' || c[i] == '\"') {
                            context = c[i];
                            break;
                        }
                        context = 45;
                        curW.append(c[i]);
                        break;
                    }
                    case 34: 
                    case 39: {
                        if (c[i] == context) {
                            context = 45;
                            ret.add(curW.toString());
                            curW.setLength(0);
                            break;
                        }
                        curW.append(c[i]);
                    }
                }
                continue;
            }
            switch (c[i]) {
                case ' ': {
                    if (curW.length() > 0) {
                        ret.add(curW.toString());
                        curW.setLength(0);
                    }
                    context = c[i];
                    continue block7;
                }
                default: {
                    curW.append(c[i]);
                }
            }
        }
        if (curW.length() > 0) {
            ret.add(curW.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    private class HelpFullAction
    extends AbstractAction {
        HelpFullAction(ConnectionManager cm) {
            super(cm, "helpAll", "Provides full help for all commands.", 0);
        }

        @Override
        public boolean invoke(String[] args) {
            System.out.println("This is command line client which operates on UNICORE VO system. Type 'help <CMD>' to get help on every command. Available commands are:");
            Iterator it = CLCExecutor.this.actions.values().iterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            Collections.sort(list);
            Collections.reverse(list);
            for (AbstractAction a : list) {
                System.out.println("\n------------------------------------\nCommand: " + a.getName() + "\n");
                System.out.println(a.getHelp());
            }
            return true;
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction(ConnectionManager cm) {
            super(cm, "help", "Provides help. Use without arguments to get generic help or with command name as parameter to get help on the specified command usage.");
        }

        @Override
        public boolean invoke(String[] args) {
            if (args.length > 1) {
                AbstractAction a = (AbstractAction)CLCExecutor.this.actions.get(args[1]);
                if (a == null) {
                    System.out.println("Command " + args[1] + " is not known");
                } else {
                    System.out.println("Help for command: " + args[1] + "\n" + a.getHelp());
                }
            } else {
                System.out.println("This is command line client which operates on UNICORE VO system. Type 'help <CMD>' to get help on every command. Available commands are:\n");
                Iterator it = CLCExecutor.this.actions.values().iterator();
                ArrayList<AbstractAction> list = new ArrayList<AbstractAction>();
                while (it.hasNext()) {
                    AbstractAction aa = (AbstractAction)it.next();
                    if (list.contains(aa)) continue;
                    list.add(aa);
                }
                Collections.sort(list);
                Collections.reverse(list);
                for (AbstractAction a : list) {
                    System.out.print("  " + a.getName());
                    for (String alias : a.getAliases()) {
                        System.out.print(" (" + alias + ")");
                    }
                    System.out.println();
                }
            }
            return true;
        }
    }

    private static class ExitAction
    extends AbstractAction {
        ExitAction(ConnectionManager cm) {
            super(cm, "exit", "Exits application", 0, "quit");
        }

        @Override
        public boolean invoke(String[] args) {
            return false;
        }
    }
}

