/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class AreEquivalentAction
extends AbstractAction {
    AreEquivalentAction(ConnectionManager cm) {
        super(cm, "areEquivalent", "Checks if two given identities are equivalent.\nSyntax:\n   areEquivalent <dn|x509|email> <identity1> <dn|x509|email> <identity2>\nExample:\n  areEquivalent email ann@example.com email ann@example.org\n", 4);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Identity i = this.getIdentity(args[1], args[2], null);
        if (i == null) {
            return true;
        }
        Identity i2 = this.getIdentity(args[3], args[4], null);
        if (i2 == null) {
            return true;
        }
        Boolean is = this.cm.qTime == null ? Boolean.valueOf(this.cm.voQuery.areEquivalent(i, i2)) : Boolean.valueOf(this.cm.voQueryHistory.areEquivalent(i, i2, this.cm.qTime));
        System.out.println(i + " is equivalnet to " + i2 + "? " + is.toString().toUpperCase() + "\n");
        return true;
    }
}

