/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.xtreemfs;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.xtreemfs.XtreemFSTransferBase;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.io.InputStream;
import java.net.URI;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.ProtocolType;

public class XtreemFSUpload
extends XtreemFSTransferBase {
    private static final Logger logger = Log.getLogger((String)"unicore.services", XtreemFSUpload.class);
    private final String workdir;
    private final String source;
    private final URI target;

    public XtreemFSUpload(Configuration configuration, Client client, String workdir, String source, URI target) {
        super(configuration, client);
        this.workdir = workdir;
        this.source = source;
        this.target = target;
    }

    public long getDataSize() {
        return 0L;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target.toString();
    }

    public long getTransferredBytes() {
        return 0L;
    }

    public void run() {
        this.status = IFileTransfer.Status.RUNNING;
        try {
            String baseDir = this.configuration.getProperty("xtreemfs.mountpoint");
            if (baseDir == null) {
                baseDir = this.xtreemProperties.getValue("mountpoint");
            }
            if (baseDir != null) {
                this.exportLocally(baseDir);
            } else {
                this.uploadToRemoteSMS();
            }
            this.status = IFileTransfer.Status.DONE;
        }
        catch (Exception ex) {
            this.status = IFileTransfer.Status.FAILED;
            this.statusMessage = Log.createFaultMessage((String)"File export failed.", (Throwable)ex);
        }
    }

    protected void exportLocally(String baseDir) throws Exception {
        if (baseDir == null) {
            throw new IllegalStateException("No local XtreemFS mountpoint defined.");
        }
        String realTarget = baseDir + SMSBaseImpl.urlDecode((String)this.makeTarget());
        String realSource = this.workdir + "/" + this.source;
        this.ensureDirectoriesExist(realTarget);
        TSI tsi = this.configuration.getTargetSystemInterface(this.client);
        tsi.cp(realSource, realTarget);
        logger.info((Object)("Copied: " + realSource + " to " + realTarget));
    }

    String makeTarget() {
        return this.target.getRawSchemeSpecificPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadToRemoteSMS() throws Exception {
        StorageClient sms = this.createStorageClient();
        logger.info((Object)("Uploading to remote SMS " + sms.getUrl()));
        FileTransferClient ftc = sms.getImport(this.makeTarget(), new ProtocolType.Enum[]{ProtocolType.BFT});
        TSI tsi = this.configuration.getStorageTSI(this.workdir, this.client);
        InputStream is = tsi.getInputStream(this.source);
        try {
            ftc.writeAllData(is);
        }
        finally {
            try {
                ftc.destroy();
            }
            catch (Exception ex) {}
            try {
                is.close();
            }
            catch (Exception ex) {}
        }
    }
}

