/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.xtreemfs;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.xtreemfs.Constants;
import de.fzj.unicore.uas.xtreemfs.XtreemProperties;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.ETDAssertionForwarding;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.OptionNotSupportedException;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class XtreemFSTransferBase
implements IFileTransfer,
Constants {
    protected IFileTransfer.Status status;
    protected String statusMessage = "OK.";
    protected final Configuration configuration;
    protected final Client client;
    protected final String uuid;
    protected IFileTransfer.OverwritePolicy overwrite;
    private String parentActionID;
    protected volatile boolean aborted = false;
    protected boolean ignoreFailure;
    protected final Kernel kernel;
    protected final XtreemProperties xtreemProperties;

    public XtreemFSTransferBase(Configuration configuration, Client client) {
        this.configuration = configuration;
        this.client = client;
        this.uuid = UUID.randomUUID().toString();
        this.status = IFileTransfer.Status.CREATED;
        this.kernel = (Kernel)configuration.getComponentInstanceOfType(Kernel.class);
        this.xtreemProperties = (XtreemProperties)((Object)this.kernel.getAttribute(XtreemProperties.class));
    }

    public boolean abort() {
        this.aborted = true;
        return true;
    }

    public String getParentActionID() {
        return this.parentActionID;
    }

    public IFileTransfer.Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getUniqueId() {
        return this.uuid;
    }

    public boolean isStreaming() {
        return false;
    }

    public Map<String, Serializable> pause() {
        return null;
    }

    public void resume(Map<String, Serializable> status) {
    }

    protected void ensureDirectoriesExist(String path) throws Exception {
        String dir = path.substring(0, path.lastIndexOf("/"));
        TSI tsi = this.configuration.getTargetSystemInterface(this.client);
        tsi.mkdir(dir);
    }

    protected StorageClient createStorageClient() throws Exception {
        ClientProperties sec = this.kernel.getClientConfiguration().clone();
        ETDAssertionForwarding.configureETD((Client)this.client, (IClientConfiguration)sec);
        String address = this.xtreemProperties.getValue("url");
        if (address == null) {
            throw new IllegalStateException("No SMS for remote XtreemFS access is defined!");
        }
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(address);
        StorageClient sms = new StorageClient(epr, (IClientConfiguration)sec);
        return sms;
    }

    public void setOverwritePolicy(IFileTransfer.OverwritePolicy overwrite) throws OptionNotSupportedException {
        this.overwrite = overwrite;
    }

    public void setParentActionID(String actionID) {
        this.parentActionID = actionID;
    }

    public void setStorageAdapter(IStorageAdapter adapter) {
    }

    public String getProtocol() {
        return "xtreemfs";
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }
}

