/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.xtreemfs;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.xtreemfs.XtreemFSTransferBase;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.io.OutputStream;
import java.net.URI;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.ProtocolType;

public class XtreemFSDownload
extends XtreemFSTransferBase {
    private static final Logger logger = Log.getLogger((String)"unicore.services", XtreemFSDownload.class);
    private final String workdir;
    private final URI source;
    private final String target;

    public XtreemFSDownload(Configuration configuration, Client client, String workdir, URI source, String target) {
        super(configuration, client);
        this.source = source;
        this.target = target;
        this.workdir = workdir;
    }

    public long getDataSize() {
        return 0L;
    }

    public String getSource() {
        return this.source.toString();
    }

    public String getTarget() {
        return this.target;
    }

    public long getTransferredBytes() {
        return 0L;
    }

    public void run() {
        this.status = IFileTransfer.Status.RUNNING;
        try {
            String baseDir = this.configuration.getProperty("xtreemfs.mountpoint");
            if (baseDir == null) {
                baseDir = this.xtreemProperties.getValue("mountpoint");
            }
            if (baseDir != null) {
                this.importLocally(baseDir);
            } else {
                this.downloadFromRemote();
            }
            this.status = IFileTransfer.Status.DONE;
        }
        catch (Exception ex) {
            this.status = IFileTransfer.Status.FAILED;
            this.statusMessage = Log.createFaultMessage((String)"File import failed.", (Throwable)ex);
        }
    }

    protected void importLocally(String baseDir) throws Exception {
        if (baseDir == null) {
            throw new IllegalStateException("No local XtreemFS mountpoint defined.");
        }
        String realSource = baseDir + SMSBaseImpl.urlDecode((String)this.makeSource());
        String realTarget = this.workdir + "/" + this.target;
        this.ensureDirectoriesExist(realTarget);
        TSI tsi = this.configuration.getTargetSystemInterface(this.client);
        tsi.cp(realSource, realTarget);
        logger.info((Object)("Copied: " + realSource + " to " + realTarget));
    }

    String makeSource() {
        return this.source.getRawSchemeSpecificPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadFromRemote() throws Exception {
        StorageClient sms = this.createStorageClient();
        logger.info((Object)("Downloading from remote SMS " + sms.getUrl()));
        FileTransferClient ftc = sms.getExport(this.makeSource(), new ProtocolType.Enum[]{ProtocolType.BFT});
        TSI tsi = this.configuration.getStorageTSI(this.workdir, this.client);
        OutputStream os = tsi.getOutputStream(this.target);
        try {
            ftc.readAllData(os);
        }
        finally {
            try {
                ftc.destroy();
            }
            catch (Exception ex) {}
            try {
                os.close();
            }
            catch (Exception ex) {}
        }
    }
}

