/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep.result;

import edu.virginia.vcgr.jsdl.sweep.result.AbstractResult;
import edu.virginia.vcgr.jsdl.sweep.result.FileSweepResultItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileSweepResult
extends AbstractResult {
    private static final long serialVersionUID = -5956452701803889257L;
    Map<Integer, List<FileSweepResultItem>> replacementsMap = new HashMap<Integer, List<FileSweepResultItem>>();

    public FileSweepResult() {
    }

    public FileSweepResult(Map<Integer, List<FileSweepResultItem>> replacementsMap) {
        this.replacementsMap = replacementsMap;
    }

    @Override
    public AbstractResult.SweepTypes getSweepType() {
        return AbstractResult.SweepTypes.FILESWEEP;
    }

    public void addDataStagingRecord(Integer index, FileSweepResultItem item) {
        List<FileSweepResultItem> individualReplacements = this.replacementsMap.get(index);
        if (individualReplacements != null) {
            individualReplacements.add(item);
        } else {
            individualReplacements = new ArrayList<FileSweepResultItem>();
            individualReplacements.add(item);
        }
        this.replacementsMap.put(index, individualReplacements);
    }

    public Map<Integer, List<FileSweepResultItem>> getDataStagingRecord() {
        return this.replacementsMap;
    }

    @Override
    public FileSweepResult clone() {
        HashMap<Integer, List<FileSweepResultItem>> clonedReplacementsMap = new HashMap<Integer, List<FileSweepResultItem>>();
        ArrayList<FileSweepResultItem> clonedList = new ArrayList<FileSweepResultItem>();
        for (Integer key : this.replacementsMap.keySet()) {
            List<FileSweepResultItem> itemList = this.replacementsMap.get(key);
            for (FileSweepResultItem fileSweepResultItem : itemList) {
                clonedList.add(fileSweepResultItem.clone());
            }
            clonedReplacementsMap.put(new Integer(key), clonedList);
        }
        return new FileSweepResult(clonedReplacementsMap);
    }

    public String toString() {
        return String.format("[SweepType: %s]", new Object[]{this.getSweepType()});
    }
}

