/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep.parameters.xpath;

import edu.virginia.vcgr.jsdl.sweep.SweepException;
import edu.virginia.vcgr.jsdl.sweep.eval.SweepTargetIdentifier;
import edu.virginia.vcgr.jsdl.sweep.parameters.xpath.WholeNodeSweepTargetIdentifier;
import edu.virginia.vcgr.jsdl.sweep.parameters.xpath.XPathFunctionalTargetIdentifierFactory;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

public class XPathTargetIdentifierFactory {
    private static final Pattern XPATH_FUNCTION_PATTERN = Pattern.compile("^\\s*([^\\(]+)\\(([^\\)]+)\\)\\s*$");

    private static List<String> formArgumentList(String argListString) {
        if (!argListString.contains(",")) {
            return new Vector<String>(0);
        }
        String[] split = argListString.split(",");
        Vector<String> argList = new Vector<String>(split.length);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if ((item = item.trim()).length() != 0) {
                argList.add(item);
            }
            ++n2;
        }
        return argList;
    }

    public static SweepTargetIdentifier createIdentifier(NamespaceContext nsContext, String xpathExpression) throws SweepException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath path = factory.newXPath();
            path.setNamespaceContext(nsContext);
            Matcher matcher = XPATH_FUNCTION_PATTERN.matcher(xpathExpression);
            if (matcher.matches()) {
                return XPathFunctionalTargetIdentifierFactory.createIdentifier(path, matcher.group(1), XPathTargetIdentifierFactory.formArgumentList(matcher.group(2)));
            }
            return new WholeNodeSweepTargetIdentifier(xpathExpression, path.compile(xpathExpression));
        }
        catch (XPathExpressionException e) {
            throw new SweepException("Unable to compile XPath expression.", e);
        }
    }
}

