/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep.parameters.xpath;

import edu.virginia.vcgr.jsdl.sweep.SweepException;
import edu.virginia.vcgr.jsdl.sweep.eval.SweepTarget;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class WholeNodeSweepTarget
implements SweepTarget {
    private Node _node;

    private static void removeAllChildren(Node target) {
        NodeList list = target.getChildNodes();
        int lcv = 0;
        while (lcv < list.getLength()) {
            target.removeChild(list.item(lcv));
            ++lcv;
        }
    }

    private static void replaceAllChildren(Node target, Node source) {
        WholeNodeSweepTarget.removeAllChildren(target);
        NodeList list = source.getChildNodes();
        int lcv = 0;
        while (lcv < list.getLength()) {
            Node tmp = list.item(lcv);
            tmp = tmp.cloneNode(true);
            target.getOwnerDocument().adoptNode(tmp);
            target.appendChild(tmp);
            ++lcv;
        }
    }

    public WholeNodeSweepTarget(Node node) {
        this._node = node;
    }

    @Override
    public void replace(Object value) throws SweepException {
        if (value instanceof Node) {
            WholeNodeSweepTarget.replaceAllChildren(this._node, (Node)value);
        } else if (value instanceof String) {
            WholeNodeSweepTarget.removeAllChildren(this._node);
            this._node.setTextContent((String)value);
        } else if (value instanceof Integer) {
            WholeNodeSweepTarget.removeAllChildren(this._node);
            this._node.setTextContent(((Integer)value).toString());
        } else if (value instanceof Double) {
            WholeNodeSweepTarget.removeAllChildren(this._node);
            this._node.setTextContent(((Double)value).toString());
        } else {
            throw new SweepException(String.format("Don't know how to replace a %s with a %s.", Node.class, value.getClass()));
        }
    }
}

