/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep.parameters.xpath;

import edu.virginia.vcgr.jsdl.sweep.SweepException;
import edu.virginia.vcgr.jsdl.sweep.eval.SweepTarget;
import edu.virginia.vcgr.jsdl.sweep.eval.SweepTargetIdentifier;
import edu.virginia.vcgr.jsdl.sweep.parameters.xpath.SubstringNodeSweepTarget;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;

class SubstringFunctionalSweepTargetIdentifier
implements SweepTargetIdentifier {
    private String _stringExpression;
    private XPathExpression _nodePath;
    private int _startIndex;
    private int _length;

    SubstringFunctionalSweepTargetIdentifier(XPath path, List<String> arguments) throws XPathExpressionException {
        if (arguments.size() < 2 || arguments.size() > 3) {
            throw new IllegalArgumentException("Must have two or three arguments.");
        }
        this._stringExpression = arguments.get(0);
        this._nodePath = path.compile(this._stringExpression);
        this._startIndex = Integer.parseInt(arguments.get(1)) - 1;
        this._length = arguments.size() == 3 ? Integer.parseInt(arguments.get(2)) : -1;
    }

    @Override
    public SweepTarget identify(Node context, Map<String, Object> params) throws SweepException {
        try {
            Node evaluationNode = (Node)this._nodePath.evaluate(context, XPathConstants.NODE);
            if (evaluationNode == null) {
                throw new SweepException(String.format("XPath expression %s didn't match any nodes.", this._stringExpression));
            }
            return new SubstringNodeSweepTarget(evaluationNode, this._startIndex, this._length);
        }
        catch (XPathExpressionException e) {
            throw new SweepException("Unable to evaluate XPath expression.", e);
        }
    }
}

