/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep.parameters.xpath;

import edu.virginia.vcgr.jsdl.sweep.parameters.xpath.DeltaPoint;
import java.util.Iterator;
import java.util.TreeSet;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

class DeltaInformation
implements Cloneable {
    static final String USER_HANDLER_KEY = "edu.virginia.vcgr.jsdl.sweep.parameters.xpath.substring-delta-information";
    private TreeSet<DeltaPoint> _deltas;
    static UserDataHandler USER_DATA_HANDLER = new UserDataHandler(){

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            if (data != null && src != null && dst != null && src != dst) {
                dst.setUserData(key, ((DeltaInformation)data).clone(), this);
            }
        }
    };

    private DeltaInformation(TreeSet<DeltaPoint> deltas) {
        this._deltas = deltas;
    }

    DeltaInformation() {
        this(new TreeSet<DeltaPoint>(DeltaPoint.ORDER_COMPARATOR));
    }

    final String replace(String original, String replacement, int start, int length) {
        int delta;
        String ret;
        DeltaPoint point = null;
        Iterator<DeltaPoint> iterator = this._deltas.iterator();
        while (iterator.hasNext()) {
            point = iterator.next();
            if (point.start() > start) break;
            start += point.delta();
        }
        if (length < 0) {
            ret = String.valueOf(original.substring(0, start)) + replacement;
            delta = replacement.length() - (original.length() - start);
        } else {
            ret = String.valueOf(original.substring(0, start)) + replacement + original.substring(start + length);
            delta = replacement.length() - length;
        }
        while (point != null) {
            point.shift(delta);
            point = iterator.hasNext() ? iterator.next() : null;
        }
        this._deltas.add(new DeltaPoint(start, delta));
        return ret;
    }

    public final Object clone() {
        TreeSet<DeltaPoint> deltas = new TreeSet<DeltaPoint>(DeltaPoint.ORDER_COMPARATOR);
        for (DeltaPoint pt : this._deltas) {
            deltas.add((DeltaPoint)pt.clone());
        }
        return new DeltaInformation(deltas);
    }

    public final String toString() {
        return this._deltas.toString();
    }
}

