/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep.parameters.filesweep;

import edu.virginia.vcgr.jsdl.sweep.SweepException;
import edu.virginia.vcgr.jsdl.sweep.eval.SweepTarget;
import edu.virginia.vcgr.jsdl.sweep.parameters.filesweep.FileToken;
import edu.virginia.vcgr.jsdl.sweep.parameters.filesweep.JSDLNameSpaceContext;
import edu.virginia.vcgr.jsdl.sweep.parameters.filesweep.TemplateFile;
import edu.virginia.vcgr.jsdl.sweep.result.FileSweepResult;
import edu.virginia.vcgr.jsdl.sweep.result.FileSweepResultItem;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;

public class FileTokenSweepTarget
implements SweepTarget {
    private final List<TemplateFile> templateFiles;
    private final List<FileToken> fileTokens;
    private final Node doc;
    private final Map<String, Object> params;
    private FileSweepResult result = null;
    private static XPath xpath = XPathFactory.newInstance().newXPath();

    static {
        xpath.setNamespaceContext(new JSDLNameSpaceContext());
    }

    public FileTokenSweepTarget(Node context, List<TemplateFile> templateFiles, List<FileToken> fileTokens, Map<String, Object> params) {
        this.templateFiles = templateFiles;
        this.fileTokens = fileTokens;
        this.doc = context;
        this.params = params;
        this.result = (FileSweepResult)params.get("sweep.result.key");
        if (this.result == null) {
            this.result = new FileSweepResult();
        }
    }

    @Override
    public void replace(Object functionValue) throws SweepException {
        String valueString = null;
        valueString = functionValue instanceof Node ? ((Node)functionValue).getTextContent() : functionValue.toString();
        FileSweepResultItem item = null;
        for (TemplateFile templateFile : this.templateFiles) {
            String fileName = templateFile.getFileName();
            String fileSystemName = templateFile.getFilesystemName();
            Integer index = null;
            try {
                int numInstances = this.checkDuplicity(fileName, fileSystemName);
                if (numInstances <= 0 || numInstances > 1) {
                    throw new Exception("Cannot sweep NULL or duplicate data staging elements in the JSDL instance matching your criteria.");
                }
                index = this.getDataStagingIndex(fileName, fileSystemName);
                if (index == null || index < 0) {
                    throw new Exception("Couldn't locate the requested template's '" + fileName + "'" + (fileSystemName == null ? "" : "and '" + fileSystemName + "'"));
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                throw new SweepException("Error processing File Sweep." + e.getMessage());
            }
            HashSet<FileToken> fileTokenSet = new HashSet<FileToken>(this.fileTokens);
            if (fileTokenSet.size() < this.fileTokens.size()) {
                throw new SweepException("Cannot sweep duplicate File Tokens");
            }
            fileTokenSet = null;
            for (FileToken token : this.fileTokens) {
                item = new FileSweepResultItem();
                item.setDataStagingFileName(fileName);
                if (token.assignDefault != null) {
                    item.setDataStagingOldToken(token.getValue());
                    item.setDataStagingNewToken(token.getAssignDefault());
                } else {
                    item.setDataStagingOldToken(token.getValue());
                    item.setDataStagingNewToken(valueString);
                }
                this.result.addDataStagingRecord(index, item);
            }
            if (item != null) continue;
            throw new SweepException("Cannot find file: " + fileName + " in the jsdl data staging");
        }
        this.params.put("sweep.result.key", this.result);
    }

    private Integer getDataStagingIndex(String fileName, String fileSystemName) throws Exception {
        StringBuffer indexQueryBuffer = new StringBuffer();
        indexQueryBuffer.append("count(//jsdl:JobDescription/jsdl:DataStaging[jsdl:FileName='" + fileName + "'");
        if (fileSystemName != null || fileSystemName == "") {
            indexQueryBuffer.append(" and jsdl:FilesystemName='" + fileSystemName + "'");
        }
        indexQueryBuffer.append("]");
        indexQueryBuffer.append("/preceding-sibling::jsdl:DataStaging)+1.");
        XPathExpression expression = xpath.compile(indexQueryBuffer.toString());
        Double d = (Double)expression.evaluate(this.doc, XPathConstants.NUMBER);
        int index = d.intValue() - 1;
        return index;
    }

    private int checkDuplicity(String fileName, String fileSystemName) throws Exception {
        StringBuffer countQueryBuffer = new StringBuffer();
        countQueryBuffer.append("count(//jsdl:JobDescription/jsdl:DataStaging[jsdl:FileName='" + fileName + "'");
        if (fileSystemName != null) {
            countQueryBuffer.append(" and jsdl:FilesystemName='" + fileSystemName + "'");
        }
        countQueryBuffer.append("])");
        XPathExpression expression = xpath.compile(countQueryBuffer.toString());
        Double d = (Double)expression.evaluate(this.doc, XPathConstants.NUMBER);
        return d.intValue();
    }
}

