/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep.parameters;

import edu.virginia.vcgr.jsdl.sweep.parameters.NamespaceBinding;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;

public class NamespaceBindingsContext
implements NamespaceContext {
    private Map<String, Collection<String>> _uri2PrefixMap;
    private Map<String, String> _prefix2UriMap;

    public NamespaceBindingsContext(Collection<NamespaceBinding> bindings) {
        this._uri2PrefixMap = new HashMap<String, Collection<String>>(bindings.size());
        this._prefix2UriMap = new HashMap<String, String>(bindings.size());
        for (NamespaceBinding binding : bindings) {
            this._prefix2UriMap.put(binding.prefix(), binding.namespaceURI());
            Collection<String> list = this._uri2PrefixMap.get(binding.namespaceURI());
            if (list == null) {
                list = new Vector<String>();
                this._uri2PrefixMap.put(binding.namespaceURI(), list);
            }
            list.add(binding.prefix());
        }
    }

    @Override
    public final String getNamespaceURI(String prefix) {
        return this._prefix2UriMap.get(prefix);
    }

    @Override
    public final Iterator<String> getPrefixes(String namespaceURI) {
        Collection<String> ret = this._uri2PrefixMap.get(namespaceURI);
        if (ret == null) {
            return null;
        }
        return ret.iterator();
    }

    @Override
    public final String getPrefix(String namespaceURI) {
        Iterator<String> iter = this.getPrefixes(namespaceURI);
        if (iter == null) {
            return null;
        }
        return iter.next();
    }
}

