/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep.functions;

import edu.virginia.vcgr.jsdl.sweep.SweepFunction;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class LoopIntegerSweepFunction
implements SweepFunction,
Serializable {
    static final long serialVersionUID = 0L;
    private static final int DEFAULT_STEP = 1;
    @XmlTransient
    private int _size = -1;
    @XmlAttribute(name="start", required=true)
    private int _start;
    @XmlAttribute(name="end", required=true)
    private int _end;
    @XmlAttribute(name="step", required=false)
    private Integer _step;
    @XmlElement(namespace="http://schemas.ogf.org/jsdl/2009/03/sweep/functions", name="Exception", required=false, nillable=false)
    private Set<Integer> _exceptions;

    public LoopIntegerSweepFunction(int start, int end, int step) {
        this._start = start;
        this._end = end;
        this._step = step;
        this._exceptions = new HashSet<Integer>();
    }

    public LoopIntegerSweepFunction(int start, int end) {
        this(start, end, 1);
    }

    public LoopIntegerSweepFunction() {
        this(0, 0);
    }

    public final int start() {
        return this._start;
    }

    public final int end() {
        return this._end;
    }

    public final int step() {
        if (this._step != null) {
            return this._step;
        }
        return 1;
    }

    public final Set<Integer> exceptions() {
        return this._exceptions;
    }

    @Override
    public final int size() {
        if (this._size < 0) {
            int count = 0;
            int step = this._step == null ? 1 : this._step;
            int value = this._start;
            while (value <= this._end) {
                if (this._exceptions == null || !this._exceptions.contains(value)) {
                    ++count;
                }
                value += step;
            }
            this._size = count;
        }
        return this._size;
    }

    @Override
    public final Iterator<Object> iterator() {
        return new LoopIterator();
    }

    private class LoopIterator
    implements Iterator<Object> {
        private int _nextValue;
        private int _actualStep;
        private Set<Integer> _actualExceptions;

        private LoopIterator() {
            this._nextValue = LoopIntegerSweepFunction.this._start;
            this._actualStep = LoopIntegerSweepFunction.this._step == null ? 1 : LoopIntegerSweepFunction.this._step;
            this._actualExceptions = LoopIntegerSweepFunction.this._exceptions == null ? new HashSet() : LoopIntegerSweepFunction.this._exceptions;
            while (this._actualExceptions.contains(this._nextValue) && this._nextValue <= LoopIntegerSweepFunction.this._end) {
                this._nextValue += this._actualStep;
            }
        }

        @Override
        public final boolean hasNext() {
            return this._nextValue <= LoopIntegerSweepFunction.this._end;
        }

        @Override
        public final Object next() {
            Integer ret = new Integer(this._nextValue);
            do {
                this._nextValue += this._actualStep;
            } while (this._nextValue <= LoopIntegerSweepFunction.this._end && this._actualExceptions.contains(new Integer(this._nextValue)));
            return ret;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Not allowed to remove elements from this iterator.");
        }
    }
}

