/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep.functions;

import edu.virginia.vcgr.jsdl.sweep.SweepFunction;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class LoopDoubleSweepFunction
implements SweepFunction,
Serializable {
    static final long serialVersionUID = 0L;
    @XmlTransient
    private int _size = -1;
    @XmlAttribute(name="start", required=true)
    private double _start;
    @XmlAttribute(name="end", required=true)
    private double _end;
    @XmlAttribute(name="step", required=true)
    private double _step;
    @XmlElement(namespace="http://schemas.ogf.org/jsdl/2009/03/sweep/functions", name="Exception", required=false, nillable=false)
    private Set<Double> _exceptions;

    public LoopDoubleSweepFunction(double start, double end, double step) {
        this._start = start;
        this._end = end;
        this._step = step;
        this._exceptions = new HashSet<Double>();
    }

    public LoopDoubleSweepFunction() {
        this(0.0, 0.0, 0.1);
    }

    public final double start() {
        return this._start;
    }

    public final double end() {
        return this._end;
    }

    public final double step() {
        return this._step;
    }

    public final Set<Double> exceptions() {
        return this._exceptions;
    }

    @Override
    public final int size() {
        if (this._size < 0) {
            int count = 0;
            double value = this._start;
            while (value <= this._end) {
                if (this._exceptions == null || !this._exceptions.contains(value)) {
                    ++count;
                }
                value += this._step;
            }
            this._size = count;
        }
        return this._size;
    }

    @Override
    public final Iterator<Object> iterator() {
        return new LoopIterator();
    }

    private class LoopIterator
    implements Iterator<Object> {
        private double _nextValue;
        private Set<Double> _actualExceptions;

        private LoopIterator() {
            this._nextValue = LoopDoubleSweepFunction.this._start;
            this._actualExceptions = LoopDoubleSweepFunction.this._exceptions == null ? new HashSet() : LoopDoubleSweepFunction.this._exceptions;
            while (this._actualExceptions.contains(this._nextValue) && this._nextValue <= LoopDoubleSweepFunction.this._end) {
                this._nextValue += LoopDoubleSweepFunction.this._step;
            }
        }

        @Override
        public final boolean hasNext() {
            return this._nextValue <= LoopDoubleSweepFunction.this._end;
        }

        @Override
        public final Object next() {
            Double ret = new Double(this._nextValue);
            do {
                this._nextValue += LoopDoubleSweepFunction.this._step;
            } while (!(this._nextValue > LoopDoubleSweepFunction.this._end) && this._actualExceptions.contains(new Double(this._nextValue)));
            return ret;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Not allowed to remove elements from this iterator.");
        }
    }
}

