/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep;

import edu.virginia.vcgr.jsdl.JSDLUtility;
import edu.virginia.vcgr.jsdl.JobDefinition;
import edu.virginia.vcgr.jsdl.sweep.Sweep;
import edu.virginia.vcgr.jsdl.sweep.SweepException;
import edu.virginia.vcgr.jsdl.sweep.SweepListener;
import edu.virginia.vcgr.jsdl.sweep.XmlUtility;
import edu.virginia.vcgr.jsdl.sweep.eval.EvaluationContext;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Node;

public class SweepUtility {
    public static boolean hasSweep(Node jobDefNode) throws Exception {
        JobDefinition jobDef = XmlUtility.convertJobNodetoJAXB(jobDefNode);
        List<Sweep> sweeps = jobDef.parameterSweeps();
        return sweeps != null && sweeps.size() > 0;
    }

    public static int sweepSize(JobDefinition jobDef) {
        if (jobDef == null) {
            return 0;
        }
        List<Sweep> sweeps = jobDef.parameterSweeps();
        if (sweeps == null || sweeps.size() == 0) {
            return 1;
        }
        int count = 0;
        for (Sweep sweep : sweeps) {
            count += sweep.size();
        }
        return count;
    }

    public static int sweepSize(Node jobDefNode) throws SweepException {
        JobDefinition jobDef = null;
        try {
            jobDef = XmlUtility.convertJobNodetoJAXB(jobDefNode);
        }
        catch (JAXBException e) {
            throw new SweepException("Unable to unmarshall job definition instance", e);
        }
        return SweepUtility.sweepSize(jobDef);
    }

    public static void performSweep(JAXBContext context, JobDefinition jobDef, SweepListener listener) throws SweepException {
        if (context == null) {
            context = JSDLUtility.JSDLContext;
        }
        if (jobDef == null || listener == null) {
            return;
        }
        List<Sweep> parameterSweeps = jobDef.parameterSweeps();
        SweepCreator sweepCreator = new SweepCreator(jobDef, parameterSweeps, listener, context);
        sweepCreator.createSweep();
    }

    public static void performSweep(Node jobDefNode, SweepListener listener) throws SweepException {
        JobDefinition jobDef;
        try {
            jobDef = XmlUtility.convertJobNodetoJAXB(jobDefNode);
        }
        catch (JAXBException e) {
            throw new SweepException("Unable to marshall Job Definition instance.", e);
        }
        SweepUtility.performSweep(JSDLUtility.JSDLContext, jobDef, listener);
    }

    public static void performSweep(JobDefinition jobDef, SweepListener listener) throws SweepException {
        SweepUtility.performSweep(JSDLUtility.JSDLContext, jobDef, listener);
    }

    private static class SweepCreator {
        private List<Sweep> _parameterSweeps;
        private SweepListener _listener;
        private JobDefinition _jobDefinition;
        private JAXBContext _context;
        private Node _jobDefinitionNode;
        private boolean useDOMNode = false;

        private SweepCreator(JobDefinition jobDefinition, List<Sweep> parameterSweeps, SweepListener listener, JAXBContext context) {
            this._parameterSweeps = parameterSweeps;
            this._listener = listener;
            this._jobDefinition = jobDefinition;
            this._context = context;
        }

        private SweepCreator(Node jobDefinitionNode, List<Sweep> parameterSweeps, SweepListener listener, JAXBContext context) {
            this._parameterSweeps = parameterSweeps;
            this._listener = listener;
            this._jobDefinitionNode = jobDefinitionNode;
            this._context = context;
            this.useDOMNode = true;
        }

        public void createSweep() throws SweepException {
            if (this._parameterSweeps == null || this._parameterSweeps.size() == 0) {
                DOMResult domResult = new DOMResult();
                Node jobDefNode = domResult.getNode();
                try {
                    this._context.createMarshaller().marshal((Object)this._jobDefinition, jobDefNode);
                    this._listener.emitSweepInstance(jobDefNode, null);
                }
                catch (JAXBException jAXBException) {}
            } else {
                Vector<Sweep> copy = new Vector<Sweep>(this._parameterSweeps);
                this._parameterSweeps.clear();
                try {
                    EvaluationContext evaluationContext;
                    HashMap<String, Object> initParams = new HashMap<String, Object>();
                    DOMResult domResult = new DOMResult();
                    if (!this.useDOMNode) {
                        this._context.createMarshaller().marshal((Object)this._jobDefinition, (Result)domResult);
                        evaluationContext = new EvaluationContext(this._listener, this._context.createUnmarshaller(), domResult.getNode(), initParams);
                    } else {
                        evaluationContext = new EvaluationContext(this._listener, this._context.createUnmarshaller(), this._jobDefinitionNode, initParams);
                    }
                    for (Sweep sweep : copy) {
                        sweep.evaluate(evaluationContext);
                    }
                }
                catch (JAXBException e) {
                    throw new SweepException("Unable to marshall Job Definition document.", e);
                }
                catch (Exception e1) {
                    throw new SweepException("Unable to perform sweep." + e1.getMessage(), e1);
                }
            }
        }
    }
}

