/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep;

import edu.virginia.vcgr.jsdl.sweep.Countable;
import edu.virginia.vcgr.jsdl.sweep.SweepException;
import edu.virginia.vcgr.jsdl.sweep.SweepFunction;
import edu.virginia.vcgr.jsdl.sweep.SweepParameter;
import edu.virginia.vcgr.jsdl.sweep.eval.Evaluable;
import edu.virginia.vcgr.jsdl.sweep.eval.EvaluationStep;
import edu.virginia.vcgr.jsdl.sweep.eval.SweepTargetIdentifier;
import edu.virginia.vcgr.jsdl.sweep.functions.LoopDoubleSweepFunction;
import edu.virginia.vcgr.jsdl.sweep.functions.LoopIntegerSweepFunction;
import edu.virginia.vcgr.jsdl.sweep.functions.ValuesSweepFunction;
import edu.virginia.vcgr.jsdl.sweep.parameters.DocumentNodeSweepParameter;
import edu.virginia.vcgr.jsdl.sweep.parameters.filesweep.FileSweepParameter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

public class SweepAssignment
implements Serializable,
Countable,
Iterable<Evaluable> {
    static final long serialVersionUID = 0L;
    @XmlElements(value={@XmlElement(namespace="http://schemas.ogf.org/jsdl/2009/03/sweep", name="DocumentNode", required=true, nillable=false, type=DocumentNodeSweepParameter.class), @XmlElement(namespace="http://schemas.ogf.org/jsdl/2009/03/file-sweep", name="FileSweep", required=true, nillable=false, type=FileSweepParameter.class)})
    private List<SweepParameter> _parameters;
    @XmlElements(value={@XmlElement(namespace="http://schemas.ogf.org/jsdl/2009/03/sweep/functions", name="Values", required=true, nillable=false, type=ValuesSweepFunction.class), @XmlElement(namespace="http://schemas.ogf.org/jsdl/2009/03/sweep/functions", name="LoopInteger", required=true, nillable=false, type=LoopIntegerSweepFunction.class), @XmlElement(namespace="http://schemas.ogf.org/jsdl/2009/03/sweep/functions", name="LoopDouble", required=true, nillable=false, type=LoopDoubleSweepFunction.class)})
    private SweepFunction _function;

    private SweepAssignment() {
        this(null, new SweepParameter[0]);
    }

    public SweepAssignment(SweepFunction function, SweepParameter ... parameters) {
        this._function = function;
        this._parameters = new Vector<SweepParameter>(parameters.length);
        SweepParameter[] sweepParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            SweepParameter parameter = sweepParameterArray[n2];
            this._parameters.add(parameter);
            ++n2;
        }
    }

    public final void addParameter(SweepParameter parameter) {
        this._parameters.add(parameter);
    }

    public final List<SweepParameter> sweepParameters() {
        return this._parameters;
    }

    public final SweepFunction sweepFunction() {
        return this._function;
    }

    @Override
    public final int size() {
        return this._function.size();
    }

    @Override
    public final Iterator<Evaluable> iterator() {
        try {
            return new EvaluationIterator();
        }
        catch (SweepException e) {
            throw new RuntimeException("Unable to create evaluation iterator.", e);
        }
    }

    private class EvaluationIterator
    implements Iterator<Evaluable> {
        private Iterator<Object> _values;
        private List<SweepTargetIdentifier> _targets;

        private EvaluationIterator() throws SweepException {
            this._values = SweepAssignment.this._function == null ? null : SweepAssignment.this._function.iterator();
            if (SweepAssignment.this._parameters == null) {
                SweepAssignment.this._parameters = new Vector(0);
            }
            this._targets = new Vector<SweepTargetIdentifier>(SweepAssignment.this._parameters.size());
            for (SweepParameter parameter : SweepAssignment.this._parameters) {
                this._targets.add(parameter.targetIdentifier());
            }
        }

        @Override
        public final boolean hasNext() {
            if (this._values == null) {
                return false;
            }
            return this._values.hasNext();
        }

        @Override
        public final Evaluable next() {
            return new EvaluationStep(this._targets, this._values.next());
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Not allowed to remove elements from this iterator.");
        }
    }
}

