/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.sweep;

import edu.virginia.vcgr.jsdl.sweep.Countable;
import edu.virginia.vcgr.jsdl.sweep.SweepAssignment;
import edu.virginia.vcgr.jsdl.sweep.SweepException;
import edu.virginia.vcgr.jsdl.sweep.eval.Evaluable;
import edu.virginia.vcgr.jsdl.sweep.eval.EvaluationContext;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(namespace="http://schemas.ogf.org/jsdl/2009/03/sweep", name="Sweep")
public class Sweep
implements Serializable,
Countable,
Evaluable {
    static final long serialVersionUID = 0L;
    @XmlElement(namespace="http://schemas.ogf.org/jsdl/2009/03/sweep", name="Assignment", required=true, nillable=false)
    private List<SweepAssignment> _assignments;
    @XmlElement(namespace="http://schemas.ogf.org/jsdl/2009/03/sweep", name="Sweep", required=false, nillable=false)
    private List<Sweep> _subSweeps;
    Map<String, Object> p = null;

    public Sweep(SweepAssignment ... assignments) {
        this._assignments = new Vector<SweepAssignment>(assignments.length);
        SweepAssignment[] sweepAssignmentArray = assignments;
        int n = assignments.length;
        int n2 = 0;
        while (n2 < n) {
            SweepAssignment assignment = sweepAssignmentArray[n2];
            this._assignments.add(assignment);
            ++n2;
        }
        this._subSweeps = new Vector<Sweep>();
    }

    public Sweep() {
        this._assignments = new Vector<SweepAssignment>();
        this._subSweeps = new Vector<Sweep>();
    }

    public final void addAssignment(SweepAssignment assignment) {
        this._assignments.add(assignment);
    }

    public final void addSubSweep(Sweep subSweep) {
        this._subSweeps.add(subSweep);
    }

    public final List<SweepAssignment> assignments() {
        return this._assignments;
    }

    public final List<Sweep> subSweeps() {
        return this._subSweeps;
    }

    @Override
    public final int size() {
        int subSweepSize;
        int assignmentSize = 0;
        if (this._assignments.size() > 0) {
            assignmentSize = this._assignments.get(0).size();
        }
        if (this._subSweeps == null || this._subSweeps.size() == 0) {
            subSweepSize = 1;
        } else {
            subSweepSize = 0;
            for (Sweep subSweep : this._subSweeps) {
                subSweepSize += subSweep.size();
            }
        }
        return assignmentSize * subSweepSize;
    }

    @Override
    public void evaluate(EvaluationContext context) throws SweepException {
        boolean emittable = this._subSweeps == null || this._subSweeps.isEmpty();
        Vector<Iterator<Evaluable>> concurrentAssignments = new Vector<Iterator<Evaluable>>(this._assignments.size());
        Iterator<Evaluable> firstAssignment = null;
        for (SweepAssignment assignment : this._assignments) {
            Iterator<Evaluable> e = assignment.iterator();
            if (firstAssignment == null) {
                firstAssignment = e;
            }
            concurrentAssignments.add(e);
        }
        while (firstAssignment.hasNext()) {
            EvaluationContext firstCopy = (EvaluationContext)context.clone();
            for (Iterator iterator : concurrentAssignments) {
                ((Evaluable)iterator.next()).evaluate(firstCopy);
            }
            if (emittable) {
                firstCopy.emit();
                continue;
            }
            for (Sweep sweep : this._subSweeps) {
                EvaluationContext secondCopy = (EvaluationContext)firstCopy.clone();
                sweep.evaluate(secondCopy);
            }
        }
    }
}

