/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.rangevalue;

import edu.virginia.vcgr.jsdl.rangevalue.Boundary;
import edu.virginia.vcgr.jsdl.rangevalue.Exact;
import edu.virginia.vcgr.jsdl.rangevalue.Matchable;
import edu.virginia.vcgr.jsdl.rangevalue.Range;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;

@XmlType(propOrder={"_upperBoundedRange", "_lowerBoundedRange", "_exacts", "_ranges"})
public class RangeValue
implements Serializable,
Matchable {
    static final long serialVersionUID = 0L;
    @XmlAnyAttribute
    private Map<QName, String> _anyAttributes = new HashMap<QName, String>();
    @XmlElement(namespace="http://schemas.ggf.org/jsdl/2005/11/jsdl", name="UpperBoundedRange", required=false)
    private Boundary _upperBoundedRange = null;
    @XmlElement(namespace="http://schemas.ggf.org/jsdl/2005/11/jsdl", name="LowerBoundedRange", required=false)
    private Boundary _lowerBoundedRange = null;
    @XmlElement(namespace="http://schemas.ggf.org/jsdl/2005/11/jsdl", name="Exact", required=false)
    private List<Exact> _exacts = new LinkedList<Exact>();
    @XmlElement(namespace="http://schemas.ggf.org/jsdl/2005/11/jsdl", name="Range", required=false)
    private List<Range> _ranges = new LinkedList<Range>();

    public final void upperBoundedRange(Boundary boundary) {
        this._upperBoundedRange = boundary;
    }

    public final Boundary upperBoundedRange() {
        return this._upperBoundedRange;
    }

    public final void lowerBoundedRange(Boundary boundary) {
        this._lowerBoundedRange = boundary;
    }

    public final Boundary lowerBoundedRange() {
        return this._lowerBoundedRange;
    }

    public final List<Exact> exacts() {
        return this._exacts;
    }

    public final List<Range> ranges() {
        return this._ranges;
    }

    @Override
    public final boolean matches(Number number) {
        if (this._upperBoundedRange != null && this._upperBoundedRange.isCeiling(number)) {
            return true;
        }
        if (this._lowerBoundedRange != null && this._lowerBoundedRange.isFloor(number)) {
            return true;
        }
        for (Exact e : this._exacts) {
            if (!e.matches(number)) continue;
            return true;
        }
        for (Range r : this._ranges) {
            if (!r.matches(number)) continue;
            return true;
        }
        return false;
    }

    public final Map<QName, String> anyAttributes() {
        return this._anyAttributes;
    }
}

