/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl.mapping;

import edu.virginia.vcgr.jsdl.OperatingSystemNames;
import edu.virginia.vcgr.jsdl.ProcessorArchitecture;
import edu.virginia.vcgr.jsdl.mapping.ArchitectureMapping;
import edu.virginia.vcgr.jsdl.mapping.OSMapping;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class Mappings {
    private static Logger _logger = Logger.getLogger(Mappings.class);
    private static Map<String, ProcessorArchitecture> _archMapping;
    private static Map<String, OperatingSystemNames> _osMapping;

    static {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ArchitectureMapping.class, OSMapping.class});
            ArchitectureMapping aMapping = Mappings.loadArchitectureMapping(context);
            OSMapping oMapping = Mappings.loadOSMapping(context);
            _archMapping = aMapping == null ? new HashMap<String, ProcessorArchitecture>() : aMapping.mapping();
            _osMapping = oMapping == null ? new HashMap<String, OperatingSystemNames>() : oMapping.mapping();
        }
        catch (JAXBException e) {
            _logger.error((Object)"Unable to create JAXB Context.", (Throwable)e);
        }
    }

    private static Object loadMapping(JAXBContext context, String resourceName) {
        InputStream in = null;
        try {
            in = Mappings.class.getResourceAsStream(resourceName);
            if (in == null) {
                throw new FileNotFoundException(String.format("Couldn't find mapping resource \"%s\".", resourceName));
            }
            Object object = context.createUnmarshaller().unmarshal(in);
            return object;
        }
        catch (JAXBException e) {
            _logger.error((Object)String.format("Unable to parse mapping file %s.", resourceName), (Throwable)e);
        }
        catch (FileNotFoundException fnfe) {
            _logger.error((Object)String.format("Unable to find resource %s.", resourceName), (Throwable)fnfe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    private static ArchitectureMapping loadArchitectureMapping(JAXBContext context) {
        return (ArchitectureMapping)Mappings.loadMapping(context, "arch-map.xml");
    }

    private static OSMapping loadOSMapping(JAXBContext context) {
        return (OSMapping)Mappings.loadMapping(context, "os-map.xml");
    }

    public static Map<String, OperatingSystemNames> osMap() {
        return _osMapping;
    }

    public static Map<String, ProcessorArchitecture> architectureMap() {
        return _archMapping;
    }
}

