/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl;

import edu.virginia.vcgr.jsdl.mapping.Mappings;

public enum ProcessorArchitecture {
    sparc("SPARC"),
    powerpc("Power PC"),
    x86("X86"),
    x86_32("X86 32-bit"),
    x86_64("X86 64-bit"),
    parisc("PaRISC"),
    mips("MIPS"),
    ia64("Itanium 64-bit"),
    arm("ARM"),
    other("Other");

    private String _label;

    private ProcessorArchitecture(String label) {
        this._label = label;
    }

    public String toString() {
        return this._label;
    }

    public static ProcessorArchitecture getCurrentArchitecture() {
        String osArch = System.getProperty("os.arch");
        if (osArch == null) {
            return null;
        }
        return Mappings.architectureMap().get(osArch);
    }
}

