/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl;

import edu.virginia.vcgr.jsdl.JSDLUtility;
import edu.virginia.vcgr.jsdl.JobDefinition;
import edu.virginia.vcgr.jsdl.sweep.SweepException;
import edu.virginia.vcgr.jsdl.sweep.SweepListener;
import edu.virginia.vcgr.jsdl.sweep.SweepUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class ParameterSweeper {
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.err.println("USAGE:  ParameterSweeper <input-jsdl> <output-directory>");
            System.exit(1);
        }
        File source = new File(args[0]);
        File targetDir = new File(args[1]);
        if (!source.exists() || !source.isFile()) {
            System.err.format("JSDL File %s does not exist.\n", args[0]);
            System.exit(1);
        }
        if (!targetDir.exists()) {
            System.err.format("Target directory %s does not exist.\n", args[1]);
            System.exit(1);
        }
        if (!targetDir.isDirectory()) {
            System.err.format("Target %s is not a directory.\n", args[1]);
            System.exit(1);
        }
        try {
            Unmarshaller unmarshaller = JSDLUtility.JSDLContext.createUnmarshaller();
            JobDefinition jobDef = (JobDefinition)unmarshaller.unmarshal(source);
            System.out.format("Generating %d jobs from sweep file %s\n", SweepUtility.sweepSize(jobDef), source);
            SweepUtility.performSweep(jobDef, (SweepListener)new SweepListenerImpl(source, targetDir));
        }
        catch (Throwable e) {
            System.err.format("Unable to sweep JSDL file:  %s\n", e);
            System.exit(1);
        }
    }

    private static class SweepListenerImpl
    implements SweepListener {
        private Marshaller _marshaller = JSDLUtility.JSDLContext.createMarshaller();
        private File _source;
        private File _targetDir;
        private int _nextInstance;

        private SweepListenerImpl(File source, File targetDir) throws JAXBException {
            this._marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this._source = source;
            this._targetDir = targetDir;
            this._nextInstance = 0;
        }

        @Override
        public void emitSweepInstance(Node jobDefNode, Map<String, Object> initParams) throws SweepException {
            FileOutputStream fos = null;
            File output = null;
            try {
                output = new File(this._targetDir, String.format("%s.%d", this._source.getName(), this._nextInstance++));
                fos = new FileOutputStream(output);
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.transform(new DOMSource(jobDefNode), new StreamResult(fos));
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

