/*
 * Decompiled with CFR 0.152.
 */
package edu.virginia.vcgr.jsdl;

import edu.virginia.vcgr.jsdl.mapping.Mappings;

public enum OperatingSystemNames {
    Unknown,
    MACOS("Mac OS X"),
    ATTUNIX("AT & T Unix"),
    DGUX,
    DECNT("DEC NT"),
    Tru64_UNIX("Tru 64 Unix"),
    OpenVMS("Open VMS"),
    HPUX,
    AIX,
    MVS,
    OS400,
    OS_2("OS 2"),
    JavaVM("Java VM"),
    MSDOS("MS-DOS"),
    WIN3x("Windows 3x"),
    WIN95("Windows 95"),
    WIN98("Windows 98"),
    WINNT("Windows NT"),
    WINCE("Windows CE"),
    NCR3000,
    NetWare,
    OSF,
    DC_OS("DC OS"),
    Reliant_UNIX("Reliant UNIX"),
    SCO_UnixWare("SCO UnixWare"),
    SCO_OpenServer("SCO OpenServer"),
    Sequent,
    IRIX,
    Solaris,
    SunOS,
    U6000,
    ASERIES("A-SERIES"),
    TandemNSK("Tandem NSK"),
    TandemNT("Tandem NT"),
    BS2000,
    LINUX("Linux"),
    Lynx,
    XENIX,
    VM,
    Interactive_UNIX("Interactive UNIX"),
    BSDUNIX("BSD UNIX"),
    FreeBSD("Free BSD"),
    NetBSD("Net BSD"),
    GNU_Hurd("GNU Hurd"),
    OS9,
    MACH_Kernel("MACH Kernel"),
    Inferno,
    QNX,
    EPOC,
    IxWorks,
    VxWorks,
    MiNT,
    BeOS,
    HP_MPE,
    NextStep,
    PalmPilot("Palm Pilot"),
    Rhapsody,
    Windows_2000("Windows 2000"),
    Dedicated,
    OS_390("OS 390"),
    VSE,
    TPF,
    Windows_R_Me("Windows R Me"),
    Caldera_Open_UNIX("Caldera Open UNIX"),
    OpenBSD,
    Not_Applicable("Not Applicable"),
    Windows_XP("Windows XP"),
    z_OS("z OS"),
    other;

    private String _label;

    private OperatingSystemNames() {
        this(null);
    }

    private OperatingSystemNames(String label) {
        this._label = label;
        if (this._label == null) {
            this._label = this.name();
        }
    }

    public String toString() {
        return this._label;
    }

    public boolean isWindows() {
        return this == Windows_XP || this == WINNT || this == Windows_2000 || this == Windows_R_Me || this == WINCE || this == WIN98 || this == WIN95 || this == WIN3x;
    }

    public boolean isMacOSX() {
        return this == MACOS;
    }

    public boolean isLinux() {
        return this == LINUX;
    }

    public static OperatingSystemNames getCurrentOperatingSystem() {
        String javaValue = System.getProperty("os.name");
        if (javaValue == null) {
            return null;
        }
        return Mappings.osMap().get(javaValue);
    }

    public static String getCurrentVersion() {
        return System.getProperty("os.version");
    }
}

