/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.xnjs;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.U6HttpConnectionFactory;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.XNJS;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.Manager;
import de.fzj.unicore.xnjs.io.CompositeFindOptions;
import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.SimpleFindOptions;
import de.fzj.unicore.xnjs.io.http.IConnectionFactory;
import de.fzj.unicore.xnjs.jsdl.Incarnation;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.simple.SimpleIDB;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.IExecutionSystemInformation;
import de.fzj.unicore.xnjs.tsi.IReservation;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.unigrids.services.atomic.types.PermissionsType;
import org.unigrids.services.atomic.types.TextInfoType;
import org.unigrids.x2006.x04.services.sms.FilterType;

public class XNJSFacade {
    private static final Logger logger = LogUtil.getLogger((String)"unicore", XNJSFacade.class);
    private static final String DEFAULT_INSTANCE = XNJSFacade.class.getName() + "_DEFAULT_XNJS";
    private XNJS xnjs;
    private String id;
    private final Kernel kernel;

    private static synchronized XNJSInstancesMap getXNJSInstanceMap(Kernel kernel) {
        XNJSInstancesMap map = (XNJSInstancesMap)kernel.getAttribute(XNJSInstancesMap.class);
        if (map == null) {
            map = new XNJSInstancesMap();
            kernel.setAttribute(XNJSInstancesMap.class, (Object)map);
        }
        return map;
    }

    public static synchronized XNJSFacade get(String xnjsReference, Kernel kernel) {
        String ref = xnjsReference != null ? xnjsReference : DEFAULT_INSTANCE;
        XNJSFacade r = (XNJSFacade)XNJSFacade.getXNJSInstanceMap(kernel).get(ref);
        if (r == null) {
            r = new XNJSFacade(kernel);
            if (xnjsReference == null) {
                r.doDefaultInit(kernel);
            }
            XNJSFacade.getXNJSInstanceMap(kernel).put(ref, r);
            r.setID(ref);
        }
        return r;
    }

    private XNJSFacade(Kernel kernel) {
        this.kernel = kernel;
    }

    private void setID(String id) {
        this.id = id;
    }

    public void configure(String configFileName) throws Exception {
        this.configure(new FileInputStream(configFileName));
    }

    public void configure(InputStream config) throws Exception {
        this.xnjs = new XNJS(config);
        this.xnjs.getConfig().registerComponent((Object)this.kernel);
        this.xnjs.getConfig().registerComponent((Object)this.kernel.getClientConfiguration());
        this.xnjs.start();
        Thread.sleep(500L);
        this.configure(this.xnjs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDefaultInit(Kernel kernel) {
        UASProperties uasConfig = (UASProperties)((Object)kernel.getAttribute(UASProperties.class));
        String config = uasConfig.getValue("targetsystemfactory.xnjs.configfile");
        if (config == null) {
            logger.info((Object)"No XNJS configured.");
        } else {
            try {
                logger.info((Object)("Configuring XNJS from file " + config));
                FileInputStream fis = new FileInputStream(config);
                try {
                    this.configure(fis);
                }
                finally {
                    fis.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error configuring XNJS.", e);
            }
        }
    }

    protected void configure(XNJS xnjs) {
        IConnectionFactory cf = (IConnectionFactory)xnjs.getConfig().getComponentInstanceOfType(IConnectionFactory.class);
        if (cf == null) {
            xnjs.getConfig().registerComponent(U6HttpConnectionFactory.class);
        }
    }

    public String getWorkdir(String actionID) {
        try {
            return this.xnjs.getConfig().getInternalManager().getAction(actionID).getExecutionContext().getWorkingDirectory();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Action makeAction(JobDefinitionDocument doc) {
        try {
            return this.xnjs.getConfig().makeAction((XmlObject)doc);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final Action getAction(String id) {
        try {
            return this.xnjs.getConfig().getInternalManager().getAction(id);
        }
        catch (Exception e) {
            LogUtil.logException((String)("Error retrieving action <" + id + ">"), (Throwable)e);
            return null;
        }
    }

    public final Integer getStatus(String id, Client client) {
        try {
            return this.xnjs.getConfig().getEMSManager().getStatus(id, client);
        }
        catch (Exception e) {
            LogUtil.logException((String)("Error retrieving action status for <" + id + ">"), (Throwable)e);
            return null;
        }
    }

    public final Integer getExitCode(String id, Client client) {
        try {
            Action a = this.xnjs.getConfig().getInternalManager().getAction(id);
            if (a != null) {
                return a.getExecutionContext().getExitCode();
            }
            return null;
        }
        catch (Exception e) {
            LogUtil.logException((String)("Error retrieving exit code for <" + id + ">"), (Throwable)e);
            return null;
        }
    }

    public final Float getProgress(String id, Client client) {
        try {
            Action a = this.xnjs.getConfig().getInternalManager().getAction(id);
            if (a != null) {
                return a.getExecutionContext().getProgress();
            }
            logger.info((Object)("Can't get progress for action " + id + ", not found on XNJS."));
            return null;
        }
        catch (Exception e) {
            LogUtil.logException((String)("Error retrieving progress for <" + id + ">"), (Throwable)e);
            return null;
        }
    }

    public void destroyAction(String id, Client client) {
        try {
            this.xnjs.getConfig().getEMSManager().destroy(id, client);
        }
        catch (Exception e) {
            LogUtil.logException((String)("Error destroying job <" + id + ">"), (Throwable)e);
        }
    }

    public final Manager getManager() {
        return this.xnjs.getConfig().getEMSManager();
    }

    public final Incarnation getGrounder() {
        return this.xnjs.getConfig().getGrounder();
    }

    public final IncarnationDataBase getIDB() {
        return this.xnjs.getConfig().getIDB();
    }

    public final Configuration getConfiguration() {
        return this.xnjs.getConfig();
    }

    public Map<String, Integer> getQueueFill() {
        return ((IExecutionSystemInformation)this.getConfiguration().getComponentInstanceOfType(IExecutionSystemInformation.class)).getQueueFill();
    }

    public int getNumberOfJobs() {
        return this.getConfiguration().getInternalManager().getAllJobs() - this.getConfiguration().getInternalManager().getDoneJobs();
    }

    public final ApplicationInfo[] getDefinedApplications() {
        SimpleIDB gr = (SimpleIDB)this.getIDB();
        return gr.getDefinedApplicationTypes();
    }

    public final ApplicationType[] getDefinedApplicationTypes() {
        ApplicationInfo[] apps = this.getDefinedApplications();
        ApplicationType[] at = new ApplicationType[apps.length];
        int i = 0;
        for (ApplicationInfo app : apps) {
            at[i] = ApplicationType.Factory.newInstance();
            at[i].setApplicationName(app.getApplicationName());
            at[i].setApplicationVersion(app.getApplicationVersion());
            ++i;
        }
        return at;
    }

    public final TextInfoType[] getDefinedTextInfo() {
        IncarnationDataBase gr = this.getIDB();
        Map infos = gr.getTextInfoProperties();
        TextInfoType[] res = new TextInfoType[infos.keySet().size()];
        int i = 0;
        for (String name : infos.keySet()) {
            res[i] = TextInfoType.Factory.newInstance();
            res[i].setName(name);
            res[i].setValue((String)infos.get(name));
            ++i;
        }
        return res;
    }

    public final ResourcesType getResources(Client c) {
        try {
            IncarnationDataBase gr = this.getIDB();
            return gr.listResources(c);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not obtain resource information from XNJS.", (Throwable)e);
            return null;
        }
    }

    public final TSI getStorageTSI(String storageRoot, Client client) {
        TSI tsi = this.xnjs.getConfig().getTargetSystemInterface(client);
        tsi.setStorageRoot(storageRoot);
        return tsi;
    }

    public final TSI getTSI(Client client) {
        return this.xnjs.getConfig().getTargetSystemInterface(client);
    }

    public boolean supportsReservation() {
        return this.xnjs.getConfig().getReservationInterface() != null;
    }

    public final IReservation getReservation() {
        return this.xnjs.getConfig().getReservationInterface();
    }

    public void shutdown() throws Exception {
        if (DEFAULT_INSTANCE.equals(this.id)) {
            logger.warn((Object)"Tried to shutdown default XNJS, ignoring...");
            return;
        }
        this.xnjs.stop();
        XNJSFacade.getXNJSInstanceMap(this.kernel).put(this.id, null);
    }

    public static void insertXNJSResourceSpec(String name, double value, ResourcesDocument resources) {
        String s = "<xnjs:ResourceSetting xmlns:xnjs=\"http://www.fz-juelich.de/unicore/xnjs/idb\"><xnjs:Name>" + name + "</xnjs:Name>" + "<xnjs:Value xmlns:jsdl=\"http://schemas.ggf.org/jsdl/2005/11/jsdl\"><jsdl:Exact>" + value + "</jsdl:Exact></xnjs:Value>" + "</xnjs:ResourceSetting>";
        try {
            XmlObject o = XmlObject.Factory.parse((String)s);
            WSServerUtilities.append((XmlObject)o, (XmlObject)resources);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Error building site-specific resource", (Throwable)e);
        }
    }

    public final long getLastIDBUpdate() {
        return this.getIDB().getLastUpdateTime();
    }

    public final CompositeFindOptions getFindOptions(FilterType filter) {
        CompositeFindOptions cfo = new CompositeFindOptions();
        if (filter != null) {
            Calendar after;
            Calendar before;
            String regExp;
            String name = filter.getNameMatch();
            if (name != null) {
                cfo.and(SimpleFindOptions.stringMatch((String)name, (boolean)false));
            }
            if ((regExp = filter.getNameMatchRegExp()) != null) {
                cfo.and(SimpleFindOptions.regExpMatch((String)regExp, (boolean)false));
            }
            if ((before = filter.getBefore()) != null) {
                cfo.and(SimpleFindOptions.lastAccessBefore((Calendar)before, (boolean)false));
            }
            if ((after = filter.getAfter()) != null) {
                cfo.and(SimpleFindOptions.lastAccessAfter((Calendar)after, (boolean)false));
            }
            if (filter.getAndFilter() != null) {
                CompositeFindOptions andCFO = this.getFindOptions(filter.getAndFilter());
                cfo.and((FileFilter)andCFO);
            }
            if (filter.getOrFilter() != null) {
                CompositeFindOptions orCFO = this.getFindOptions(filter.getOrFilter());
                cfo.or((FileFilter)orCFO);
            }
        }
        return cfo;
    }

    public static Permissions getXNJSPermissions(PermissionsType uasPermissions) {
        Permissions perm = new Permissions();
        perm.setExecutable(uasPermissions.getExecutable());
        perm.setReadable(true);
        perm.setWritable(uasPermissions.getWritable());
        return perm;
    }

    public static PermissionsType getUASPermissions(Permissions xnjsPermissions) {
        PermissionsType perm = PermissionsType.Factory.newInstance();
        perm.setExecutable(xnjsPermissions.isExecutable());
        perm.setReadable(true);
        perm.setWritable(xnjsPermissions.isWritable());
        return perm;
    }

    public List<String> listJobIDs(Client client) throws Exception {
        return Arrays.asList(this.xnjs.getConfig().getEMSManager().list(client));
    }

    public static class XNJSInstancesMap
    extends HashMap<String, XNJSFacade> {
        private static final long serialVersionUID = 1L;
    }
}

