/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.xnjs;

import de.fzj.unicore.uas.fts.FileTransferCapabilities;
import de.fzj.unicore.uas.fts.FileTransferCapability;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.U6FileTransferBase;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import eu.unicore.security.Client;
import java.net.URI;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class U6FileTransferCreator
implements IFileTransferCreator {
    protected static final Logger logger = LogUtil.getLogger((String)"unicore.services", U6FileTransferCreator.class);
    private final Configuration configuration;

    public U6FileTransferCreator(Configuration config) {
        this.configuration = config;
    }

    public IFileTransfer createFileExport(Client client, String workdir, String source, URI target, DataStagingCredentials creds) {
        String scheme = target.getScheme();
        FileTransferCapability fc = FileTransferCapabilities.getCapability(scheme);
        if (fc != null) {
            try {
                return this.createExport(fc.getExporter(), client, workdir, source, target, creds);
            }
            catch (Exception ex) {
                LogUtil.logException((String)("Error creating importer for protocol <" + scheme + ">"), (Throwable)ex);
            }
        }
        return null;
    }

    public IFileTransfer createFileImport(Client client, String workdir, URI source, String target, DataStagingCredentials creds) {
        String scheme = source.getScheme();
        FileTransferCapability fc = FileTransferCapabilities.getCapability(scheme);
        if (fc != null) {
            try {
                return this.createImport(fc.getImporter(), client, workdir, source, target, creds);
            }
            catch (Exception ex) {
                LogUtil.logException((String)("Error creating importer for protocol <" + scheme + ">"), (Throwable)ex);
            }
        }
        return null;
    }

    public String getProtocol() {
        return Arrays.toString(FileTransferCapabilities.getProtocols());
    }

    public IFileTransfer createImport(Class<? extends U6FileTransferBase> clazz, Client client, String workdir, URI source, String targetFile, DataStagingCredentials creds) {
        EndpointReferenceType epr = this.createStorageEPR(source);
        String sourceFile = this.urlDecode(source.getFragment());
        try {
            U6FileTransferBase ft = clazz.getConstructor(Configuration.class).newInstance(this.configuration);
            ft.setClient(client);
            ft.setWorkdir(workdir);
            ft.setSource(sourceFile);
            ft.setTarget(targetFile);
            ft.setSmsEPR(epr);
            ft.setExport(false);
            return ft;
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to instantiate File transfer", (Throwable)e);
            return null;
        }
    }

    public IFileTransfer createExport(Class<? extends U6FileTransferBase> clazz, Client client, String workdir, String sourceFile, URI target, DataStagingCredentials credentials) {
        EndpointReferenceType epr = this.createStorageEPR(target);
        String targetFile = this.urlDecode(target.getFragment());
        try {
            U6FileTransferBase ft = clazz.getConstructor(Configuration.class).newInstance(this.configuration);
            ft.setClient(client);
            ft.setSource(sourceFile);
            ft.setTarget(targetFile);
            ft.setWorkdir(workdir);
            ft.setSmsEPR(epr);
            ft.setExport(true);
            return ft;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String urlDecode(String orig) {
        try {
            return orig.replaceAll("%20", " ");
        }
        catch (Exception e) {
            return orig;
        }
    }

    protected EndpointReferenceType createStorageEPR(URI uri) {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        String withoutScheme = uri.getSchemeSpecificPart();
        String upToFragment = withoutScheme.split("#")[0];
        epr.addNewAddress().setStringValue(upToFragment);
        return epr;
    }
}

