/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.xnjs;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.ETDAssertionForwarding;
import de.fzj.unicore.wsrflite.utils.Utilities;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.PropertyType;
import org.unigrids.x2006.x04.services.sms.ExtraParametersDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class U6FileTransferBase
implements IFileTransfer,
ProgressListener<Long> {
    protected static final Logger logger = LogUtil.getLogger((String)"unicore.services", U6FileTransferBase.class);
    protected static final Logger usageLogger = Logger.getLogger((String)"unicore.services.datatransfer.USAGE");
    protected volatile long transferredBytes = 0L;
    protected long dataSize = -1L;
    protected IFileTransfer.OverwritePolicy overwrite = IFileTransfer.OverwritePolicy.OVERWRITE;
    protected final String uuid;
    protected String workdir;
    protected String source;
    protected String target;
    protected String localFile;
    protected Client client;
    protected IFileTransfer.Status status = IFileTransfer.Status.CREATED;
    protected String statusMessage = "OK.";
    protected EndpointReferenceType smsEPR;
    protected EndpointReferenceType fileTransferInstanceEpr;
    protected IClientConfiguration sec;
    protected boolean export;
    protected FileTransferClient ftc;
    private TSI tsi = null;
    private volatile boolean isCancelled = false;
    protected IStorageAdapter storageAdapter;
    protected final Configuration configuration;
    protected final Kernel kernel;
    private String parentActionID;
    private boolean ignoreFailure;
    protected long startTime = -1L;
    protected long finishTime = -11L;
    protected boolean reliableMode = false;

    public U6FileTransferBase(Configuration configuration) {
        this.configuration = configuration;
        this.uuid = Utilities.newUniqueID();
        this.kernel = (Kernel)configuration.getComponentInstanceOfType(Kernel.class);
    }

    protected abstract void doRun() throws Exception;

    protected abstract FileTransferClient getFTClient() throws Exception;

    protected void onFinishCleanup() {
        this.ftc = null;
        this.client = null;
        this.storageAdapter = null;
        this.smsEPR = null;
        this.fileTransferInstanceEpr = null;
        this.sec = null;
        this.tsi = null;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public boolean abort() {
        this.isCancelled = true;
        return true;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public String getUniqueId() {
        return this.uuid;
    }

    public boolean isStreaming() {
        return false;
    }

    public Map<String, Serializable> pause() {
        return null;
    }

    public void resume(Map<String, Serializable> state) {
    }

    public void setOverwritePolicy(IFileTransfer.OverwritePolicy overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return IFileTransfer.OverwritePolicy.OVERWRITE.equals((Object)this.overwrite);
    }

    public void notifyProgress(Long amount) {
        this.transferredBytes += amount.longValue();
        this.finishTime = System.currentTimeMillis();
    }

    public void checkCancelled() throws ProgressListener.CancelledException {
        if (this.isCancelled) {
            throw new ProgressListener.CancelledException();
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setStorageAdapter(IStorageAdapter adapter) {
        this.storageAdapter = adapter;
    }

    public Client getClient() {
        return this.client;
    }

    public void setWorkdir(String workdir) {
        this.workdir = workdir;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public IFileTransfer.Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public EndpointReferenceType getSmsEPR() {
        return this.smsEPR;
    }

    public void setSmsEPR(EndpointReferenceType smsEPR) {
        this.smsEPR = smsEPR;
    }

    public String getParentActionID() {
        return this.parentActionID;
    }

    public void setParentActionID(String parentActionID) {
        this.parentActionID = parentActionID;
    }

    protected void initSecurityProperties() {
        try {
            Kernel kernel = (Kernel)this.configuration.getComponentInstanceOfType(Kernel.class);
            this.sec = kernel.getClientConfiguration().clone();
            ETDAssertionForwarding.configureETD((Client)this.client, (IClientConfiguration)this.sec);
            logger.debug((Object)("Creating import for client " + this.client));
        }
        catch (NullPointerException npe) {
            logger.warn((Object)"No security info available, running in non-secure mode?");
        }
    }

    protected void destroyFileTransferResource() {
        try {
            if (this.ftc != null) {
                this.ftc.destroy();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not destroy file transfer resource.", (Throwable)e);
        }
    }

    protected synchronized IStorageAdapter getStorageAdapter() throws ExecutionException {
        if (this.storageAdapter != null) {
            return this.storageAdapter;
        }
        if (this.tsi == null) {
            this.tsi = this.configuration.getTargetSystemInterface(this.client);
            this.tsi.setStorageRoot(this.workdir);
        }
        return this.tsi;
    }

    protected void checkOverwriteAllowed(IStorageAdapter adapter, String fileName) throws Exception {
        XnjsFileWithACL f;
        if (IFileTransfer.OverwritePolicy.DONT_OVERWRITE.equals((Object)this.overwrite) && (f = adapter.getProperties(fileName)) != null) {
            throw new IOException("File <" + f.getPath() + "> exists, and we have been asked to not overwrite.");
        }
    }

    protected String cleanLocalFilePath(String file) throws ExecutionException {
        return file.replaceAll("/+", "/").replace("\\/", "/").replace("/", this.getStorageAdapter().getFileSeparator());
    }

    protected void createParentDirectories(String target) throws ExecutionException {
        String s = this.getParentOfLocalFilePath(target);
        XnjsFileWithACL parent = this.getStorageAdapter().getProperties(s);
        if (parent == null) {
            this.getStorageAdapter().mkdir(s);
        } else if (!parent.isDirectory()) {
            throw new ExecutionException("Parent <" + s + "> is not a directory");
        }
    }

    protected String getParentOfLocalFilePath(String file) throws ExecutionException {
        String result = this.cleanLocalFilePath(file);
        int i = result.lastIndexOf(this.getStorageAdapter().getFileSeparator());
        return i > 0 ? result.substring(0, i) : "/";
    }

    protected String getFileName(String filePath) throws ExecutionException {
        int index = filePath.lastIndexOf("/");
        if (index > -1) {
            return filePath.substring(filePath.lastIndexOf("/") + 1);
        }
        return filePath;
    }

    protected Map<String, String> getExtraParameters() {
        return null;
    }

    protected final ExtraParametersDocument.ExtraParameters convert(Map<String, String> params) {
        ExtraParametersDocument.ExtraParameters r = ExtraParametersDocument.ExtraParameters.Factory.newInstance();
        for (Map.Entry<String, String> e : params.entrySet()) {
            PropertyType t = r.addNewParameter();
            t.setName(e.getKey());
            t.setValue(e.getValue());
        }
        return r;
    }

    public boolean isExport() {
        return this.export;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public void setReliableMode(boolean reliable) {
        this.reliableMode = reliable;
    }

    public boolean isReliableMode() {
        return this.reliableMode;
    }

    public long getElapsedTime() {
        return this.finishTime > 0L && this.startTime > 0L ? this.finishTime - this.startTime : -1L;
    }

    protected void computeMetrics() {
        this.finishTime = System.currentTimeMillis();
        long dataSize = this.getDataSize();
        long consumedMillis = this.getElapsedTime();
        float r = (float)dataSize / (float)consumedMillis;
        String what = this.isExport() ? "sent " : "received";
        String dn = this.client != null ? this.client.getDistinguishedName() : "anonymous";
        String url = this.getSmsEPR().getAddress().getStringValue();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(what + dataSize + " bytes in " + consumedMillis + " milliseconds, data rate= " + r + " kB/s"));
        }
        if (usageLogger.isInfoEnabled()) {
            usageLogger.info((Object)("[" + dn + "]" + " [" + what + "]" + " [" + dataSize + "]" + " [" + r + " kB/s]" + " [" + url + "]" + " [" + this.source + "]" + " [" + this.target + "]" + " [" + this.getProtocol() + "]" + " [" + this.parentActionID + "]"));
        }
    }
}

