/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.xnjs;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.ReliableFileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.fts.FiletransferOptions;
import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.uas.fts.rft.StoreImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.util.Pair;
import de.fzj.unicore.uas.xnjs.U6FileTransferBase;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.PermissionsType;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.x2006.x04.services.sms.ExportFileDocument;
import org.unigrids.x2006.x04.services.sms.ExportFileResponseDocument;

public abstract class U6FileImportBase
extends U6FileTransferBase {
    private GridFileType remote;
    private StorageClient sms;

    public U6FileImportBase(Configuration configuration) {
        super(configuration);
    }

    public final void run() {
        try {
            this.checkCancelled();
            this.initSecurityProperties();
            this.sms = new StorageClient(this.smsEPR, this.sec);
            this.localFile = this.target;
            if (IFileTransfer.OverwritePolicy.DONT_OVERWRITE.equals((Object)this.overwrite)) {
                XnjsFileWithACL f = null;
                try {
                    f = this.getStorageAdapter().getProperties(this.localFile);
                }
                catch (ExecutionException ex) {
                    // empty catch block
                }
                if (f != null) {
                    throw new IOException("Target file <" + this.localFile + "> exists, and we have been asked to not overwrite.");
                }
            }
            this.remote = this.sms.listProperties(this.source);
            this.status = IFileTransfer.Status.RUNNING;
            this.startTime = System.currentTimeMillis();
            if (this.remote.getIsDirectory()) {
                this.transferFolder(this.remote, this.sms, this.target);
            } else {
                this.dataSize = this.remote.getSize();
                this.createParentDirectories(this.target);
                this.transferFile(this.remote, this.sms, this.target);
            }
            this.status = IFileTransfer.Status.DONE;
            this.computeMetrics();
            this.destroyFileTransferResource();
        }
        catch (ProgressListener.CancelledException ce) {
            String msg = "File transfer cancelled.";
            this.status = IFileTransfer.Status.DONE;
            this.statusMessage = msg;
        }
        catch (Exception ex) {
            String msg = "Error executing filetransfer: " + ex.getMessage();
            LogUtil.logException((String)msg, (Throwable)ex, (Logger)logger);
            this.status = IFileTransfer.Status.FAILED;
            this.statusMessage = msg;
        }
        this.onFinishCleanup();
    }

    @Override
    protected void onFinishCleanup() {
        super.onFinishCleanup();
        this.remote = null;
    }

    protected void transferFile(GridFileType source, StorageClient sms, String target) throws Exception {
        this.checkCancelled();
        this.localFile = target;
        IStorageAdapter adapter = this.getStorageAdapter();
        XnjsFileWithACL xFile = adapter.getProperties(this.localFile);
        if (xFile != null) {
            if (xFile.isDirectory()) {
                String name = this.getFileName(source.getPath());
                this.localFile = !target.endsWith(adapter.getFileSeparator()) ? target + adapter.getFileSeparator() + name : target + name;
            }
            if (!xFile.getPermissions().isWritable()) {
                throw new IOException("Local target file is not writeable");
            }
        }
        String remoteFSID = sms.getFileSystem().getDescription();
        String localFSID = this.getStorageAdapter().getFileSystemIdentifier();
        UASProperties conf = (UASProperties)((Object)this.kernel.getAttribute(UASProperties.class));
        if (remoteFSID != null && localFSID != null && remoteFSID.equals(localFSID) && !conf.getBooleanValue("filetransfer.forceremote").booleanValue()) {
            this.transferFileLocal(source, sms, target);
        } else {
            this.transferFileFromRemote(source, sms);
        }
        this.copyPermissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferFileLocal(GridFileType source, StorageClient sms, String target) throws Exception {
        String base = sms.getFileSystem().getMountPoint();
        if (base == null || IFileTransfer.OverwritePolicy.APPEND == this.overwrite) {
            this.transferFileFromRemote(source, sms);
        } else {
            String src = base + source.getPath();
            logger.info((Object)("Optimization enabled: importing file by local copy of <" + src + "> to <" + this.localFile + ">"));
            IStorageAdapter s = this.getStorageAdapter();
            String sRoot = s.getStorageRoot();
            try {
                s.setStorageRoot("/");
                String tgt = this.workdir + "/" + this.localFile;
                this.checkOverwriteAllowed(s, tgt);
                s.cp(src, tgt);
                this.transferredBytes += source.getSize();
            }
            finally {
                s.setStorageRoot(sRoot);
            }
        }
    }

    protected void transferFileFromRemote(GridFileType source, StorageClient sms) throws Exception {
        this.checkCancelled();
        this.createNewExport(source, sms);
        if (this.ftc instanceof FiletransferOptions.IMonitorable) {
            ((FiletransferOptions.IMonitorable)this.ftc).setProgressListener((ProgressListener)this);
        }
        this.doRun();
    }

    protected void createNewExport(GridFileType source, StorageClient sms) throws Exception {
        ExportFileDocument req = ExportFileDocument.Factory.newInstance();
        req.addNewExportFile().setSource(source.getPath());
        req.getExportFile().setProtocol(ProtocolType.Enum.forString((String)this.getProtocol()));
        Map<String, String> ep = this.getExtraParameters();
        if (ep != null && ep.size() > 0) {
            req.getExportFile().setExtraParameters(this.convert(ep));
        }
        ExportFileResponseDocument res = sms.ExportFile(req);
        this.fileTransferInstanceEpr = res.getExportFileResponse().getExportEPR();
        this.ftc = this.getFTClient();
    }

    protected void transferFolder(GridFileType source, StorageClient sms, String target) throws Exception {
        ArrayList<Pair<GridFileType, String>> collection = new ArrayList<Pair<GridFileType, String>>();
        this.dataSize = this.collectRemoteFiles(collection, source, sms, target);
        for (Pair pair : collection) {
            GridFileType currentSource = (GridFileType)pair.getM1();
            String currentTarget = (String)pair.getM2();
            if (currentSource.getIsDirectory()) {
                this.createParentDirectories(currentTarget + "/file");
                ++this.transferredBytes;
                continue;
            }
            this.transferFile(currentSource, sms, currentTarget);
        }
    }

    protected long collectRemoteFiles(List<Pair<GridFileType, String>> collection, GridFileType sourceFolder, StorageClient sms, String targetFolder) throws Exception {
        long result = 1L;
        collection.add((Pair<GridFileType, String>)new Pair((Object)sourceFolder, (Object)targetFolder));
        for (GridFileType child : sms.listDirectory(sourceFolder.getPath())) {
            String relative = child.getPath().substring(sourceFolder.getPath().length() + 1);
            String target = targetFolder + this.getStorageAdapter().getFileSeparator() + relative;
            if (child.getIsDirectory()) {
                result += this.collectRemoteFiles(collection, child, sms, target);
                continue;
            }
            collection.add((Pair<GridFileType, String>)new Pair((Object)child, (Object)target));
            result += child.getSize();
        }
        return result;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    protected void doRun() throws Exception {
        if (this.reliableMode) {
            try {
                this.doRunReliably();
            }
            catch (IllegalArgumentException iae) {
                Log.logException((String)"", (Throwable)iae, (Logger)logger);
                this.doRunUnreliably();
            }
        } else {
            this.doRunUnreliably();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRunUnreliably() throws Exception {
        OutputStream os = null;
        boolean append = IFileTransfer.OverwritePolicy.APPEND.equals((Object)this.overwrite);
        os = this.getStorageAdapter().getOutputStream(this.localFile, append);
        try {
            this.checkCancelled();
            if (this.ftc instanceof FiletransferOptions.IMonitorable) {
                ((FiletransferOptions.IMonitorable)this.ftc).setProgressListener((ProgressListener)this);
            }
            this.ftc.readAllData(os);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    protected void doRunReliably() throws Exception {
        TSI tsi = null;
        if (!(this.getStorageAdapter() instanceof TSI)) {
            throw new IllegalArgumentException("Reliable mode not supported for <" + this.getStorageAdapter().getClass() + ">");
        }
        tsi = (TSI)this.getStorageAdapter();
        boolean ftcOK = true;
        do {
            try {
                StoreImpl store = new StoreImpl(this.client, tsi, this.configuration, this.target, this.ftc.getSourceFileSize());
                this.singleRFTRun(store);
            }
            catch (ProgressListener.CancelledException ce) {
                throw ce;
            }
            catch (Exception ex) {
                ftcOK = this.checkOK(this.ftc);
                if (!ftcOK) {
                    this.createNewExport(this.remote, this.sms);
                }
                throw ex;
            }
        } while (!ftcOK);
    }

    protected void singleRFTRun(StoreImpl store) throws Exception {
        ReliableFileTransferClient rft = new ReliableFileTransferClient((FiletransferOptions.SupportsPartialRead)this.ftc, (ReliableFileTransferClient.Store)store);
        rft.setProgressListener((ProgressListener)this);
        this.checkCancelled();
        rft.run();
    }

    protected boolean checkOK(FileTransferClient ftc) {
        ResourceUnavailableFault ex = null;
        do {
            try {
                ftc.getCurrentTime();
            }
            catch (ResourceUnavailableFault ruf) {
                ex = ruf;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {}
            }
            catch (Exception ex1) {
                return false;
            }
        } while (ex != null && ex instanceof ResourceUnavailableFault);
        return true;
    }

    protected void copyPermissions() throws Exception {
        PermissionsType p = this.remote.getPermissions();
        Permissions perm = XNJSFacade.getXNJSPermissions(p);
        this.getStorageAdapter().chmod(this.localFile, perm);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Copied remote permissions to :" + perm));
        }
    }
}

