/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.xnjs;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.fts.FiletransferOptions;
import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.util.Pair;
import de.fzj.unicore.uas.xnjs.U6FileTransferBase;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.x2006.x04.services.sms.ImportFileDocument;
import org.unigrids.x2006.x04.services.sms.ImportFileResponseDocument;

public abstract class U6FileExportBase
extends U6FileTransferBase {
    private StorageClient sms;
    private GridFileType gridFile;

    public U6FileExportBase(Configuration configuration) {
        super(configuration);
    }

    public final void run() {
        try {
            this.checkCancelled();
            this.initSecurityProperties();
            this.sms = new StorageClient(this.smsEPR, this.sec);
            this.localFile = this.source = this.cleanLocalFilePath(this.source);
            this.status = IFileTransfer.Status.RUNNING;
            this.startTime = System.currentTimeMillis();
            if (this.isDirectory(this.source)) {
                this.transferFolder(this.source, this.sms, this.target);
            } else {
                this.dataSize = this.computeFileSize(this.source);
                this.transferFile(this.source, this.sms, this.target);
            }
            this.status = IFileTransfer.Status.DONE;
            this.computeMetrics();
            this.destroyFileTransferResource();
        }
        catch (ProgressListener.CancelledException ce) {
            String msg = "File transfer cancelled.";
            this.status = IFileTransfer.Status.DONE;
            this.statusMessage = msg;
        }
        catch (Exception ex) {
            String msg = "Error executing filetransfer: " + ex.getMessage();
            LogUtil.logException((String)msg, (Throwable)ex, (Logger)logger);
            this.status = IFileTransfer.Status.FAILED;
            this.statusMessage = msg;
        }
        this.onFinishCleanup();
    }

    @Override
    protected void onFinishCleanup() {
        super.onFinishCleanup();
        this.sms = null;
        this.gridFile = null;
    }

    protected void transferFile(String source, StorageClient sms, String target) throws Exception {
        this.checkCancelled();
        target = this.checkIfTargetIsADirectory(source, sms, target);
        String remoteFSID = sms.getFileSystem().getDescription();
        String localFSID = this.getStorageAdapter().getFileSystemIdentifier();
        UASProperties conf = (UASProperties)((Object)this.kernel.getAttribute(UASProperties.class));
        if (remoteFSID != null && localFSID != null && remoteFSID.equals(localFSID) && !conf.getBooleanValue("filetransfer.forceremote").booleanValue()) {
            this.transferFileLocal(source, sms, target);
        } else {
            this.transferFileFromRemote(source, sms, target);
        }
        this.copyPermissions(source, sms, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferFileLocal(String source, StorageClient sms, String target) throws Exception {
        this.checkCancelled();
        String base = sms.getFileSystem().getMountPoint();
        String targetUmask = sms.getResourcePropertiesDocument().getStorageProperties().getUmask();
        if (base == null || IFileTransfer.OverwritePolicy.APPEND == this.overwrite) {
            this.transferFileFromRemote(source, sms, target);
        } else {
            String tgt = base + "/" + target;
            String src = this.workdir + "/" + source;
            IStorageAdapter s = this.getStorageAdapter();
            String sRoot = s.getStorageRoot();
            String sUmask = s.getUmask();
            try {
                s.setStorageRoot("/");
                s.setUmask(targetUmask);
                this.checkOverwriteAllowed(s, tgt);
                this.createParentDirectories(tgt);
                logger.info((Object)("Optimization enabled: exporting file by local copy of <" + src + "> to <" + tgt + ">"));
                s.cp(src, tgt);
                this.transferredBytes += s.getProperties(src).getSize();
            }
            finally {
                s.setStorageRoot(sRoot);
                s.setUmask(sUmask);
            }
        }
    }

    protected void transferFileFromRemote(String source, StorageClient sms, String target) throws Exception {
        this.checkCancelled();
        this.checkOverwriteAllowed(sms, target);
        ImportFileDocument req = ImportFileDocument.Factory.newInstance();
        req.addNewImportFile().setDestination(target);
        req.getImportFile().setProtocol(ProtocolType.Enum.forString((String)this.getProtocol()));
        boolean append = IFileTransfer.OverwritePolicy.APPEND.equals((Object)this.overwrite);
        Map<String, String> ep = this.getExtraParameters();
        if (ep != null && ep.size() > 0) {
            req.getImportFile().setExtraParameters(this.convert(ep));
        }
        req.getImportFile().setOverwrite(!append);
        ImportFileResponseDocument res = sms.ImportFile(req);
        this.fileTransferInstanceEpr = res.getImportFileResponse().getImportEPR();
        this.localFile = source;
        this.ftc = this.getFTClient();
        this.ftc.setAppend(append);
        if (this.ftc instanceof FiletransferOptions.IMonitorable) {
            ((FiletransferOptions.IMonitorable)this.ftc).setProgressListener((ProgressListener)this);
        }
        this.doRun();
    }

    protected void checkOverwriteAllowed(StorageClient sms, String fileName) throws Exception {
        if (IFileTransfer.OverwritePolicy.DONT_OVERWRITE.equals((Object)this.overwrite)) {
            GridFileType g = null;
            try {
                g = sms.listProperties(fileName);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (g != null) {
                throw new IOException("File <" + g.getPath() + "> exists, and we have been asked to not overwrite.");
            }
        }
    }

    protected String checkIfTargetIsADirectory(String source, StorageClient sms, String fileName) throws Exception {
        GridFileType g = null;
        try {
            g = sms.listProperties(fileName);
            if (g.getIsDirectory()) {
                String name = this.getFileName(this.gridFile.getPath());
                return fileName + name;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return fileName;
    }

    protected void transferFolder(String source, StorageClient sms, String target) throws Exception {
        this.checkCancelled();
        ArrayList<Pair<String, String>> collection = new ArrayList<Pair<String, String>>();
        this.dataSize = this.collectFiles(collection, source, sms, target);
        for (Pair pair : collection) {
            String currentSource = (String)pair.getM1();
            String currentTarget = (String)pair.getM2();
            if (this.isDirectory(currentSource)) {
                this.checkOverwriteAllowed(sms, currentTarget);
                sms.createDirectory(currentTarget);
                ++this.transferredBytes;
                continue;
            }
            this.transferFile(currentSource, sms, currentTarget);
        }
    }

    protected long collectFiles(List<Pair<String, String>> collection, String sourceFolder, StorageClient sms, String targetFolder) throws Exception {
        long result = 1L;
        collection.add((Pair<String, String>)new Pair((Object)sourceFolder, (Object)targetFolder));
        for (XnjsFile child : this.getStorageAdapter().ls(sourceFolder)) {
            String relative = child.getPath().substring(sourceFolder.length() + 1);
            String target = targetFolder + "/" + relative;
            if (child.isDirectory()) {
                result += this.collectFiles(collection, child.getPath(), sms, target);
                continue;
            }
            collection.add((Pair<String, String>)new Pair((Object)child.getPath(), (Object)target));
            result += child.getSize();
        }
        return result;
    }

    protected synchronized long computeFileSize(String file) throws ExecutionException, IOException {
        XnjsFileWithACL f = this.getStorageAdapter().getProperties(file);
        if (f != null) {
            return f.getSize();
        }
        throw new IOException("The file <" + file + "> does not exist or can not be accessed.");
    }

    protected boolean isDirectory(String file) throws ExecutionException {
        XnjsFileWithACL f = this.getStorageAdapter().getProperties(file);
        if (f == null) {
            throw new ExecutionException("The file <" + file + "> does not exist or can not be accessed.");
        }
        return f.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws Exception {
        InputStream is = this.getInputStream();
        try {
            this.checkCancelled();
            this.ftc.writeAllData(is);
        }
        finally {
            is.close();
        }
    }

    protected InputStream getInputStream() throws ExecutionException, IOException {
        return this.getStorageAdapter().getInputStream(this.localFile);
    }

    protected void copyPermissions(String source, StorageClient sms, String target) throws Exception {
        Permissions p = this.getStorageAdapter().getProperties(source).getPermissions();
        sms.changePermissions(target, p.isReadable(), p.isWritable(), p.isExecutable());
    }

    protected synchronized GridFileType getGridFile() {
        if (this.gridFile == null) {
            try {
                this.gridFile = this.sms.listProperties(this.target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.gridFile;
    }
}

