/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.xnjs;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.processors.DefaultProcessor;
import eu.unicore.security.Client;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ProxyCertToUspaceProcessor
extends DefaultProcessor {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.security", ProxyCertToUspaceProcessor.class);

    public ProxyCertToUspaceProcessor(Configuration c) {
        super(c);
    }

    protected void handleCreated() {
        try {
            logger.info((Object)"Writing proxy cert to uspace");
            Client c = this.action.getClient();
            String pem = (String)c.getExtraAttributes().get("Proxy");
            if (pem == null) {
                logger.info((Object)"No proxy cert found.");
                return;
            }
            this.writeToUspace(pem);
        }
        catch (Exception ex) {
            logger.error((Object)"Error writing proxy to Uspace", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToUspace(String pem) throws Exception {
        String file = this.action.getExecutionContext().getWorkingDirectory() + ".proxy";
        OutputStream os = null;
        try {
            os = this.configuration.getTargetSystemInterface(this.action.getClient()).getOutputStream(file);
            ByteArrayInputStream bis = new ByteArrayInputStream(pem.getBytes());
            IOUtils.copy((InputStream)bis, (OutputStream)os);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    void setAction(Action a) {
        this.action = a;
    }
}

