/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.util;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.impl.LockSupport;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.sms.InitDefaultStorageFactory;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class DefaultOnStartup
implements Runnable {
    private static final Logger logger = LogUtil.getLogger((String)"unicore", DefaultOnStartup.class);
    private final Kernel kernel;

    public DefaultOnStartup(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void run() {
        try {
            this.createDefaultTSFIfNotExists();
        }
        catch (Exception re) {
            throw new RuntimeException("Could not create default TSF instance.", re);
        }
        this.createDefaultStorageFactoryIfNotExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultTSFIfNotExists() throws ResourceNotCreatedException, PersistenceException {
        Home tsfHome = this.kernel.getHome("TargetSystemFactoryService");
        if (tsfHome == null) {
            logger.info((Object)"No TSF service configured for this site!");
            return;
        }
        logger.info((Object)"Initialising backend.");
        XNJSFacade.get(null, this.kernel);
        String defaultTsfName = "default_target_system_factory";
        LockSupport ls = this.kernel.getPersistenceManager().getLockSupport();
        Lock tsfLock = ls.getOrCreateLock(DefaultOnStartup.class.getName());
        if (tsfLock.tryLock()) {
            try {
                UASWSResourceImpl tsf = (UASWSResourceImpl)tsfHome.get(defaultTsfName);
                tsf.publish();
                return;
            }
            catch (ResourceUnknownException e) {
                this.doCreateTSF(tsfHome);
            }
            finally {
                tsfLock.unlock();
            }
        }
    }

    private void doCreateTSF(Home tsfHome) throws ResourceNotCreatedException {
        String defaultTsfName = "default_target_system_factory";
        HashMap<String, Object> imap = new HashMap<String, Object>();
        imap.put(WSResourceImpl.INIT_UNIQUE_ID, defaultTsfName);
        String siteName = this.kernel.getContainerProperties().getValue("sitename");
        imap.put("TSF_NAME", siteName);
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).add(2, 36);
        imap.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", c);
        tsfHome.createWSRFServiceInstance(imap);
        logger.info((Object)("Added default TSF resource " + defaultTsfName + "."));
    }

    protected void createDefaultStorageFactoryIfNotExists() {
        new InitDefaultStorageFactory(this.kernel).run();
    }
}

