/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.util;

import de.fzj.unicore.persist.impl.LockSupport;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.sms.PathedStorageImpl;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageManagementHomeImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class CreateSMSOnStartup
implements Runnable {
    private static final Logger logger = LogUtil.getLogger((String)"unicore", CreateSMSOnStartup.class);
    public static final String INSTANCE_ID = "default_storage";
    private final Kernel kernel;

    public CreateSMSOnStartup(Kernel kernel) {
        this.kernel = kernel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            try {
                Home smsHome = this.kernel.getHome("StorageManagement");
                if (smsHome == null) {
                    logger.info((Object)"No SMS configured for this site.");
                    return;
                }
                LockSupport ls = this.kernel.getPersistenceManager().getLockSupport();
                Lock smsLock = ls.getOrCreateLock(CreateSMSOnStartup.class.getName());
                if (!smsLock.tryLock()) break block8;
                try {
                    UASWSResourceImpl sms = (UASWSResourceImpl)smsHome.get(INSTANCE_ID);
                    sms.publish();
                    return;
                }
                catch (ResourceUnknownException e) {
                    try {
                        this.doCreateSMS(smsHome);
                    }
                    finally {
                        smsLock.unlock();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not add default_storage", (Throwable)e);
            }
        }
    }

    private void doCreateSMS(Home smsHome) throws ResourceNotCreatedException {
        Class clazz;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(WSResourceImpl.INIT_UNIQUE_ID, INSTANCE_ID);
        GregorianCalendar c1 = new GregorianCalendar();
        ((Calendar)c1).add(2, 72);
        map.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", c1);
        map.put(UASWSResourceImpl.INITPARAM_PUBLISH_TO_REGISTRY, Boolean.TRUE);
        UASProperties config = (UASProperties)((Object)this.kernel.getAttribute(UASProperties.class));
        String name = config.getValue("defaultsms.name");
        String dir = config.getValue("defaultsms.workdir");
        String protocols = config.getValue("defaultsms.protocols");
        if (dir == null) {
            dir = System.getProperty("java.io.tmpdir");
        }
        StorageManagementHomeImpl.StorageTypes type = (clazz = config.getClassValue("defaultsms.class", StorageManagement.class)) == null ? StorageManagementHomeImpl.StorageTypes.VARIABLE : StorageManagementHomeImpl.StorageTypes.CUSTOM;
        StorageDescription description = new StorageDescription(INSTANCE_ID, name, dir, type, clazz, protocols, true, false, false, null, "Default site storage", null);
        map.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, description);
        map.put(PathedStorageImpl.INIT_SKIP_RESOLVE, Boolean.TRUE);
        smsHome.createWSRFServiceInstance(map);
        StringBuilder msg = new StringBuilder();
        msg.append("Added default_storage resource to service StorageManagement\nUsing work dir: " + dir);
        if (clazz != null) {
            msg.append("\nUsing custom class <" + clazz + ">");
        }
        logger.info((Object)msg.toString());
    }
}

