/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.security;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.security.util.AttributeHandlingCallback;
import de.fzj.unicore.wsrflite.xfire.security.AccessControlHandler;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.xfireutil.AuthInHandler;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;
import org.jdom.Element;
import org.jdom.Namespace;

public class ProxyCertInHandler
extends AbstractHandler
implements KernelInjectable {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.security", ProxyCertInHandler.class);
    public static final Namespace PROXY_NS = Namespace.getNamespace((String)"http://www.unicore.eu/unicore6");
    public static final String PROXY = "Proxy";
    private Kernel kernel;
    private static AttributeHandlingCallback aac;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public ProxyCertInHandler(Kernel kernel) {
        this.kernel = kernel;
        this.setPhase("policy");
        this.after(AuthInHandler.class.getName());
        this.before(AccessControlHandler.class.getName());
        this.addAttributeCallback();
    }

    private void addAttributeCallback() {
        this.kernel.getSecurityManager().addCallback(this.getCallback());
    }

    public void invoke(MessageContext ctx) throws Exception {
        SecurityTokens tokens;
        Element header = ctx.getInMessage().getHeader();
        if (header == null) {
            return;
        }
        List extensions = header.getChildren(PROXY, PROXY_NS);
        if (extensions.size() == 0) {
            logger.debug((Object)"No Proxy cert header found.");
            return;
        }
        Element proxyElement = (Element)extensions.get(0);
        String proxy = proxyElement.getText();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Extracted Proxy header:\n" + proxy));
        }
        if ((tokens = (SecurityTokens)ctx.getProperty(SecurityTokens.KEY)) == null) {
            logger.warn((Object)"No security tokens found, new ones created...");
            tokens = new SecurityTokens();
            ctx.setProperty(SecurityTokens.KEY, (Object)tokens);
        }
        tokens.getContext().put(PROXY, proxy);
    }

    private synchronized AttributeHandlingCallback getCallback() {
        if (aac == null) {
            aac = new ProxyCertAttributeCallback();
        }
        return aac;
    }

    private static class ProxyCertAttributeCallback
    implements AttributeHandlingCallback {
        private ProxyCertAttributeCallback() {
        }

        public Map<String, Serializable> extractAttributes(SecurityTokens tokens) {
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            String proxy = (String)tokens.getContext().get(ProxyCertInHandler.PROXY);
            if (proxy != null) {
                result.put(ProxyCertInHandler.PROXY, (Serializable)((Object)proxy));
            }
            return result;
        }
    }
}

