/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.metadata;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.metadata.MetadataManager;
import de.fzj.unicore.uas.metadata.StorageMetadataManager;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import eu.unicore.util.Log;
import org.apache.log4j.Logger;

public class MetadataSupport {
    private static final Logger logger = Log.getLogger((String)"unicore.services", MetadataSupport.class);

    private MetadataSupport() {
    }

    public static synchronized MetadataManager getManager(Kernel kernel, UASProperties config) {
        Class managerClass = null;
        try {
            managerClass = config.getClassValue("metadata.managerClass", MetadataManager.class);
        }
        catch (Exception ex) {
            Log.logException((String)"Shouldn't happen: metadata wrongly configured.", (Throwable)ex, (Logger)logger);
        }
        if (managerClass != null) {
            try {
                MetadataManager mm = (MetadataManager)kernel.load(managerClass);
                return mm;
            }
            catch (Exception ex) {
                Log.logException((String)("Cannot instatiate metadata manager from class " + managerClass.getName()), (Throwable)ex, (Logger)logger);
            }
        }
        return null;
    }

    public static synchronized MetadataManager getManager(Kernel kernel, IStorageAdapter storage, String uniqueID) {
        MetadataManager mm = MetadataSupport.getManager(kernel, (UASProperties)((Object)kernel.getAttribute(UASProperties.class)));
        if (mm instanceof StorageMetadataManager) {
            StorageMetadataManager smm = (StorageMetadataManager)mm;
            smm.setStorageAdapter(storage, uniqueID);
        }
        return mm;
    }
}

