/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.metadata;

import de.fzj.unicore.uas.MetadataManagement;
import de.fzj.unicore.uas.client.MetadataClient;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.metadata.ExtractionStatistics;
import de.fzj.unicore.uas.metadata.ExtractionWatcher;
import de.fzj.unicore.uas.metadata.MetadataManager;
import de.fzj.unicore.uas.metadata.SearchResult;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.MetadataType;
import org.unigrids.x2006.x04.services.metadata.CreateMetadataDocument;
import org.unigrids.x2006.x04.services.metadata.CreateMetadataResponseDocument;
import org.unigrids.x2006.x04.services.metadata.DeleteMetadataDocument;
import org.unigrids.x2006.x04.services.metadata.DeleteMetadataResponseDocument;
import org.unigrids.x2006.x04.services.metadata.GetMetadataDocument;
import org.unigrids.x2006.x04.services.metadata.GetMetadataResponseDocument;
import org.unigrids.x2006.x04.services.metadata.MetadataManagementPropertiesDocument;
import org.unigrids.x2006.x04.services.metadata.SearchMetadataDocument;
import org.unigrids.x2006.x04.services.metadata.SearchMetadataResponseDocument;
import org.unigrids.x2006.x04.services.metadata.SearchResultDocument;
import org.unigrids.x2006.x04.services.metadata.StartMetadataExtractionDocument;
import org.unigrids.x2006.x04.services.metadata.StartMetadataExtractionResponseDocument;
import org.unigrids.x2006.x04.services.metadata.UpdateMetadataDocument;
import org.unigrids.x2006.x04.services.metadata.UpdateMetadataResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class BaseMetadataManagementImpl
extends UASWSResourceImpl
implements MetadataManagement {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", BaseMetadataManagementImpl.class);
    public static final String INIT_SMS_ID = BaseMetadataManagementImpl.class.getName() + "_sms_id";
    public static final String INIT_CLASS_NAME = BaseMetadataManagementImpl.class.getName() + "_class_name";
    @Persist
    protected String smsID;

    @Override
    public QName getResourcePropertyDocumentQName() {
        return MetadataManagementPropertiesDocument.type.getDocumentElementName();
    }

    @Override
    public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {
        super.initialise(serviceName, initParams);
        this.smsID = (String)initParams.get(INIT_SMS_ID);
        logger.info((Object)("Created metadata management service <" + this.getEPR().getAddress().getStringValue() + ">"));
    }

    public QName getPortType() {
        return MetadataManagement.META_PORT;
    }

    public CreateMetadataResponseDocument CreateMetadata(CreateMetadataDocument req) throws BaseFault {
        try {
            String resourceName = req.getCreateMetadata().getResourceName();
            Map metadata = MetadataClient.asMap((MetadataType)req.getCreateMetadata().getMetadata());
            this.getMetadataManager().createMetadata(resourceName, metadata);
            CreateMetadataResponseDocument res = CreateMetadataResponseDocument.Factory.newInstance();
            res.addNewCreateMetadataResponse().setMetadataCreated(true);
            return res;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw BaseFault.createFault((String)"Error creating metadata", (Throwable)ex, (boolean)true);
        }
    }

    public DeleteMetadataResponseDocument DeleteMetadata(DeleteMetadataDocument req) throws BaseFault {
        try {
            String resourceName = req.getDeleteMetadata().getResourceName();
            MetadataManager mm = this.getMetadataManager();
            mm.removeMetadata(resourceName);
            DeleteMetadataResponseDocument res = DeleteMetadataResponseDocument.Factory.newInstance();
            res.addNewDeleteMetadataResponse().setMetadataDeleted(true);
            return res;
        }
        catch (Exception ex) {
            throw BaseFault.createFault((String)"Error deleting metadata", (Throwable)ex, (boolean)true);
        }
    }

    public GetMetadataResponseDocument GetMetadata(GetMetadataDocument request) throws BaseFault {
        String resourceName = request.getGetMetadata().getResourceName();
        try {
            MetadataManager mm = this.getMetadataManager();
            Map<String, String> meta = mm.getMetadataByName(resourceName);
            GetMetadataResponseDocument gmrd = GetMetadataResponseDocument.Factory.newInstance();
            MetadataType md = MetadataClient.convert(meta);
            gmrd.addNewGetMetadataResponse().setMetadata(md);
            return gmrd;
        }
        catch (Exception ex) {
            throw BaseFault.createFault((String)"Error getting metadata", (Throwable)ex, (boolean)true);
        }
    }

    public SearchMetadataResponseDocument SearchMetadata(SearchMetadataDocument req) throws BaseFault {
        String searchString = req.getSearchMetadata().getSearchString();
        boolean isAdvancedSearch = req.getSearchMetadata().getAdvancedSearched();
        SearchMetadataResponseDocument resD = SearchMetadataResponseDocument.Factory.newInstance();
        try {
            MetadataManager mm = this.getMetadataManager();
            SearchMetadataResponseDocument.SearchMetadataResponse res = resD.addNewSearchMetadataResponse();
            List<SearchResult> result = mm.searchMetadataByContent(searchString, isAdvancedSearch);
            for (SearchResult sr : result) {
                SearchResultDocument.SearchResult r1 = res.addNewSearchResult();
                r1.setResourceName(sr.getResourceName());
            }
            return resD;
        }
        catch (Exception ex) {
            throw BaseFault.createFault((String)"Error during metadata search", (Throwable)ex, (boolean)true);
        }
    }

    public StartMetadataExtractionResponseDocument StartMetadataExtraction(StartMetadataExtractionDocument req) throws BaseFault {
        try {
            String base = req.getStartMetadataExtraction().getBasePath();
            if (base == null) {
                base = "/";
            }
            int depthLimit = (int)req.getStartMetadataExtraction().getDepthLimit();
            MetadataManager mm = this.getMetadataManager();
            Future<ExtractionStatistics> future = mm.startAutoMetadataExtraction(base, depthLimit);
            StartMetadataExtractionResponseDocument res = StartMetadataExtractionResponseDocument.Factory.newInstance();
            res.addNewStartMetadataExtractionResponse();
            try {
                EndpointReferenceType epr = this.makeTask(future);
                res.getStartMetadataExtractionResponse().setTaskReference(epr);
            }
            catch (ResourceNotCreatedException ex) {
                logger.error((Object)"Could not create Task instance for monitoring.");
            }
            return res;
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Error starting metadata extraction.", (Throwable)ex, (Logger)logger);
            throw BaseFault.createFault((String)"Error starting metadata extraction", (Throwable)ex, (boolean)true);
        }
    }

    public UpdateMetadataResponseDocument UpdateMetadata(UpdateMetadataDocument req) throws BaseFault {
        String resourceName = req.getUpdateMetadata().getResourceName();
        Map metadata = MetadataClient.asMap((MetadataType)req.getUpdateMetadata().getMetadata());
        try {
            this.getMetadataManager().updateMetadata(resourceName, metadata);
            UpdateMetadataResponseDocument res = UpdateMetadataResponseDocument.Factory.newInstance();
            res.addNewUpdateMetadataResponse().setMetadataUpdated(true);
            return res;
        }
        catch (Exception ex) {
            throw BaseFault.createFault((String)"Error updating metadata", (Throwable)ex, (boolean)true);
        }
    }

    protected EndpointReferenceType makeTask(Future<ExtractionStatistics> f) throws ResourceNotCreatedException {
        Home taskHome = this.kernel.getHome("Task");
        if (taskHome == null) {
            logger.error((Object)"Task service is not deployed.");
            return null;
        }
        HashMap<String, Object> init = new HashMap<String, Object>();
        init.put("parentServiceEPR", this.getEPR());
        init.put(INIT_PARENT_NODE, this.getNode());
        String uid = taskHome.createWSRFServiceInstance(init);
        new ExtractionWatcher(f, uid, this.kernel).run();
        EndpointReferenceType epr = WSServerUtilities.makeEPR((String)"Task", (String)uid, (Kernel)this.kernel);
        return epr;
    }

    public abstract MetadataManager getMetadataManager() throws Exception;
}

