/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.impl.tss.rp.IDBBasedResourceProperty;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import eu.unicore.security.Client;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.TotalCPUCountDocument;

public class TotalCPUsResourceProperty
extends IDBBasedResourceProperty<Object> {
    private static final long serialVersionUID = 1L;
    private TotalCPUCountDocument[] xdoc;

    public TotalCPUsResourceProperty(Resource res, String xnjsReference) {
        super(res, xnjsReference);
    }

    public TotalCPUsResourceProperty update() {
        if (this.mustUpdate()) {
            try {
                Kernel kernel = this.parentWSResource.getKernel();
                Client client = ((ResourceImpl)this.parentWSResource).getClient();
                ResourcesType res = XNJSFacade.get(this.xnjsReference, kernel).getResources(client);
                TotalCPUCountDocument cput = TotalCPUCountDocument.Factory.newInstance();
                RangeValueType cpuCount = res.getTotalCPUCount();
                if (cpuCount == null) {
                    logger.debug((Object)"Total CPU count is not set in IDB.");
                    this.xdoc = new TotalCPUCountDocument[0];
                } else {
                    this.xdoc = new TotalCPUCountDocument[1];
                    cput.setTotalCPUCount(cpuCount);
                    this.xdoc[0] = cput;
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Problem updating CPU count resourceproperty.", (Throwable)e);
                this.xdoc = new TotalCPUCountDocument[0];
            }
        }
        return this;
    }

    public TotalCPUCountDocument[] getXml() {
        return this.xdoc;
    }
}

