/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.impl.tss.rp.IDBBasedResourceProperty;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import java.util.ArrayList;
import java.util.List;
import org.unigrids.services.atomic.types.TextInfoDocument;
import org.unigrids.services.atomic.types.TextInfoType;

public class TextInfoResourceProperty
extends IDBBasedResourceProperty<TextInfoType[]> {
    private static final long serialVersionUID = 20348L;
    private List<TextInfoType> otherInfos = new ArrayList<TextInfoType>();
    private TextInfoDocument[] xdoc = new TextInfoDocument[0];

    public TextInfoResourceProperty(Resource parent, String xnjsReference) {
        super(parent, xnjsReference);
    }

    public TextInfoResourceProperty update() {
        try {
            Kernel kernel = this.parentWSResource.getKernel();
            this.setProperty(XNJSFacade.get(this.xnjsReference, kernel).getDefinedTextInfo());
            return this;
        }
        catch (Exception e) {
            logger.fatal((Object)"Could not update textinfo resourceproperty, information not available.", (Throwable)e);
            return null;
        }
    }

    public TextInfoType[] getProperty() {
        TextInfoType[] infos = new TextInfoType[this.xdoc.length];
        for (int i = 0; i < this.xdoc.length; ++i) {
            infos[i] = this.xdoc[i].getTextInfo();
        }
        return infos;
    }

    public TextInfoDocument[] getXml() {
        return this.xdoc;
    }

    public void setProperty(TextInfoType[] textInfo) {
        int i;
        this.xdoc = new TextInfoDocument[textInfo.length + this.otherInfos.size()];
        for (i = 0; i < textInfo.length; ++i) {
            this.xdoc[i] = TextInfoDocument.Factory.newInstance();
            this.xdoc[i].setTextInfo(textInfo[i]);
        }
        for (i = 0; i < this.otherInfos.size(); ++i) {
            this.xdoc[i + textInfo.length] = TextInfoDocument.Factory.newInstance();
            this.xdoc[i + textInfo.length].setTextInfo(this.otherInfos.get(i));
        }
    }

    public void add(TextInfoType textInfo) {
        this.otherInfos.add(textInfo);
        this.update();
    }

    public boolean contains(String name) {
        for (TextInfoDocument t : this.xdoc) {
            if (!name.equals(t.getTextInfo().getName())) continue;
            return true;
        }
        return false;
    }

    public String getInfo(String name) {
        for (TextInfoDocument t : this.xdoc) {
            if (!name.equals(t.getTextInfo().getName())) continue;
            return t.getTextInfo().getValue();
        }
        return null;
    }
}

