/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.impl.tss.rp.IDBBasedResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.jsdl.JSDLResourceSet;
import de.fzj.unicore.xnjs.resources.DoubleResource;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import java.util.ArrayList;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.unigrids.services.atomic.types.SiteResourceDocument;
import org.unigrids.services.atomic.types.SiteResourceType;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;

public class SiteSpecificResourcesRP
extends IDBBasedResourceProperty<ApplicationResourceType[]> {
    private static final long serialVersionUID = 1L;
    private SiteResourceDocument[] xdoc = new SiteResourceDocument[0];

    public SiteSpecificResourcesRP(Resource res, String xnjsReference) {
        super(res, xnjsReference);
    }

    public SiteResourceDocument[] getXml() {
        return this.xdoc;
    }

    public SiteSpecificResourcesRP update() {
        if (this.mustUpdate()) {
            Kernel kernel = this.parentWSResource.getKernel();
            IncarnationDataBase idb = XNJSFacade.get(this.xnjsReference, kernel).getIDB();
            ResourceSet rs = idb.getSiteResources();
            ArrayList<SiteResourceDocument> result = new ArrayList<SiteResourceDocument>();
            for (de.fzj.unicore.xnjs.resources.Resource r : rs.getResources()) {
                String name = r.getName();
                if (this.isJSDLResource(name) || Resource.Category.RANGE_VALUE != r.getCategory()) continue;
                try {
                    SiteResourceDocument srd = this.convert(r);
                    if (srd == null) continue;
                    result.add(srd);
                }
                catch (Exception e) {
                    logger.error((Object)("Could not process resource : " + r), (Throwable)e);
                }
            }
            this.xdoc = result.toArray(new SiteResourceDocument[result.size()]);
        }
        return this;
    }

    private boolean isJSDLResource(String name) {
        return JSDLResourceSet.isJSDLResourceName((String)name);
    }

    private SiteResourceDocument convert(de.fzj.unicore.xnjs.resources.Resource res) {
        try {
            DoubleResource r = (DoubleResource)res;
            SiteResourceDocument srd = SiteResourceDocument.Factory.newInstance();
            SiteResourceType sr = srd.addNewSiteResource();
            String name = r.getName();
            sr.setName(name);
            sr.setDescription(r.getDescription());
            RangeValueType val = RangeValueType.Factory.newInstance();
            if (r.getValue() != null) {
                val.addNewExact().setDoubleValue(r.getDoubleValue().doubleValue());
            }
            if (r.getLower() != null) {
                val.addNewRange().addNewLowerBound().setDoubleValue(r.getLower().doubleValue());
                if (r.getUpper() != null) {
                    val.getRangeArray(0).addNewUpperBound().setDoubleValue(r.getUpper().doubleValue());
                }
            }
            sr.setValue(val);
            return srd;
        }
        catch (Exception ex) {
            LogUtil.logException((String)("Error converting resource " + res + " to (pre 6.4) site-specific resource document."), (Throwable)ex);
            return null;
        }
    }
}

