/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.impl.tss.rp.IDBBasedResourceProperty;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import eu.unicore.security.Client;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.CPUArchitectureType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.unigrids.services.atomic.types.ProcessorDocument;
import org.unigrids.services.atomic.types.ProcessorType;

public class ProcessorResourceProperty
extends IDBBasedResourceProperty<ProcessorType> {
    private static final long serialVersionUID = -1641168248769350917L;
    private static final Logger logger = Logger.getLogger((String)"unicore.services");
    private ProcessorType processor;
    private ProcessorDocument[] xdoc;

    public ProcessorResourceProperty(Resource inst, String xnjsReference) {
        super(inst, xnjsReference);
        this.doUpdate();
    }

    public synchronized ProcessorResourceProperty update() {
        if (this.mustUpdate()) {
            this.doUpdate();
        }
        return this;
    }

    protected void doUpdate() {
        logger.debug((Object)"Updating processor resourceproperty...");
        try {
            CPUArchitectureType r2;
            RangeValueType r1;
            Kernel kernel = this.parentWSResource.getKernel();
            Client client = ((ResourceImpl)this.parentWSResource).getClient();
            ResourcesType res = XNJSFacade.get(this.xnjsReference, kernel).getResources(client);
            ProcessorType newProcessor = ProcessorType.Factory.newInstance();
            RangeValueType r = res.getIndividualCPUSpeed();
            if (r != null) {
                newProcessor.setIndividualCPUSpeed(r);
            }
            if ((r1 = res.getIndividualCPUCount()) != null) {
                newProcessor.setIndividualCPUCount(r1);
            }
            if ((r2 = res.getCPUArchitecture()) != null) {
                newProcessor.setCPUArchitecture(r2);
            }
            if (r == null && r1 == null && r2 == null) {
                throw new Exception("No entry found in the idb.");
            }
            this.setProperty(newProcessor);
        }
        catch (Exception e) {
            logger.warn((Object)"Problem updating processor resourceproperty, some related information is unavailable.", (Throwable)e);
            this.setProperty(null);
        }
    }

    public ProcessorType getProperty() {
        return this.processor;
    }

    public XmlObject[] getXml() {
        return this.xdoc;
    }

    public void setProperty(ProcessorType setTo) {
        this.processor = setTo;
        this.xdoc = new ProcessorDocument[1];
        this.xdoc[0] = ProcessorDocument.Factory.newInstance();
        this.xdoc[0].setProcessor(this.processor);
    }
}

