/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.xnjs.ems.EMSStatistics;
import eu.unicore.util.Log;
import java.math.BigInteger;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.tsf.PerformanceDataDocument;
import org.unigrids.x2006.x04.services.tsf.QueueInfoDocument;

public class PerformanceDataResourceProperty
extends ResourceProperty<Object> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Log.getLogger((String)"unicore.services", PerformanceDataResourceProperty.class);
    private final String xnjsReference;
    private final PerformanceDataDocument[] xdoc;

    public PerformanceDataResourceProperty(Resource parent, String xnjsReference) {
        super(parent);
        this.xnjsReference = xnjsReference;
        this.xdoc = new PerformanceDataDocument[1];
        this.xdoc[0] = PerformanceDataDocument.Factory.newInstance();
        this.xdoc[0].addNewPerformanceData();
    }

    public XmlObject[] getXml() {
        return this.xdoc;
    }

    public PerformanceDataResourceProperty update() {
        try {
            Kernel kernel = this.parentWSResource.getKernel();
            XNJSFacade f = XNJSFacade.get(this.xnjsReference, kernel);
            EMSStatistics stats = (EMSStatistics)f.getConfiguration().getComponentInstanceOfType(EMSStatistics.class);
            long mtq = stats.getMeanTimeQueued();
            this.xdoc[0].getPerformanceData().setMeanTimeQueued(BigInteger.valueOf(mtq));
            this.xdoc[0].getPerformanceData().setTSSType("DEFAULT");
            this.xdoc[0].getPerformanceData().setQueueInfoArray(new QueueInfoDocument.QueueInfo[0]);
            Map<String, Integer> queueFill = f.getQueueFill();
            if (queueFill != null && queueFill.size() > 0) {
                for (Map.Entry<String, Integer> e : queueFill.entrySet()) {
                    QueueInfoDocument.QueueInfo qi = this.xdoc[0].getPerformanceData().addNewQueueInfo();
                    qi.setQueueName(e.getKey());
                    qi.setActiveJobs(BigInteger.valueOf(e.getValue().intValue()));
                }
            }
        }
        catch (Exception ex) {
            Log.logException((String)"Can't update performance data", (Throwable)ex, (Logger)logger);
        }
        return this;
    }
}

