/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.impl.tss.rp.IDBBasedResourceProperty;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import eu.unicore.security.Client;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemTypeEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class OperatingSystemResourceProperty
extends IDBBasedResourceProperty<Object> {
    private static final long serialVersionUID = 1L;
    private OperatingSystemDocument[] xdoc;

    public OperatingSystemResourceProperty(Resource res, String xnjsReference) {
        super(res, xnjsReference);
    }

    public OperatingSystemResourceProperty update() {
        if (this.mustUpdate()) {
            Kernel kernel = this.parentWSResource.getKernel();
            Client client = ((ResourceImpl)this.parentWSResource).getClient();
            ResourcesType res = XNJSFacade.get(this.xnjsReference, kernel).getResources(client);
            OperatingSystemType osType = res.getOperatingSystem();
            if (osType != null) {
                OperatingSystemDocument os = OperatingSystemDocument.Factory.newInstance();
                os.setOperatingSystem((OperatingSystemType)res.getOperatingSystem().copy());
                this.xdoc = new OperatingSystemDocument[]{os};
            } else {
                logger.debug((Object)"Operating system is not defined in the IDB.");
                this.xdoc = new OperatingSystemDocument[0];
                this.xdoc[0].addNewOperatingSystem().addNewOperatingSystemType().setOperatingSystemName(OperatingSystemTypeEnumeration.UNKNOWN);
            }
        }
        return this;
    }

    public OperatingSystemDocument[] getXml() {
        return this.xdoc;
    }
}

