/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.tss.JobReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class JobReferenceResourceProperty
extends ResourceProperty<EndpointReferenceType[]> {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", JobReferenceResourceProperty.class);
    private final ArrayList<String> uuids = new ArrayList();
    private String JMS_BASE;
    public static final int LIMIT = 100;

    public JobReferenceResourceProperty(Resource parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(EndpointReferenceType[] types) {
        ArrayList<String> arrayList = this.uuids;
        synchronized (arrayList) {
            this.uuids.clear();
            for (int i = 0; i < types.length; ++i) {
                this.uuids.add(WSServerUtilities.extractResourceID((EndpointReferenceType)types[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobReferenceDocument[] getXml() {
        ArrayList<String> arrayList = this.uuids;
        synchronized (arrayList) {
            this.JMS_BASE = WSServerUtilities.makeAddress((String)"JobManagement", (String)"", (ContainerProperties)this.parentWSResource.getKernel().getContainerProperties());
            JobReferenceDocument[] xdoc = new JobReferenceDocument[Math.min(100, this.uuids.size())];
            for (int i = 0; i < this.uuids.size() && i < 100; ++i) {
                xdoc[i] = JobReferenceDocument.Factory.newInstance();
                xdoc[i].setJobReference(this.makeEPR(this.uuids.get(i)));
            }
            return xdoc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XmlObject> getXml(int offset, int length) throws IndexOutOfBoundsException {
        ArrayList<XmlObject> res = new ArrayList<XmlObject>();
        ArrayList<String> arrayList = this.uuids;
        synchronized (arrayList) {
            this.JMS_BASE = WSServerUtilities.makeAddress((String)"JobManagement", (String)"", (ContainerProperties)this.parentWSResource.getKernel().getContainerProperties());
            if (offset >= this.uuids.size()) {
                throw new IndexOutOfBoundsException("Requested offset is too large, only have <" + this.uuids.size() + "> results.");
            }
            for (int i = offset; i < offset + length && i < this.uuids.size(); ++i) {
                JobReferenceDocument r = JobReferenceDocument.Factory.newInstance();
                r.setJobReference(this.makeEPR(this.uuids.get(i)));
                res.add((XmlObject)r);
            }
            return res;
        }
    }

    public int getNumberOfElements() {
        return this.uuids.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EndpointReferenceType epr) {
        ArrayList<String> arrayList = this.uuids;
        synchronized (arrayList) {
            this.uuids.add(WSServerUtilities.extractResourceID((EndpointReferenceType)epr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        ArrayList<String> arrayList = this.uuids;
        synchronized (arrayList) {
            Iterator<String> it = this.uuids.iterator();
            while (it.hasNext()) {
                try {
                    if (!it.next().equals(id)) continue;
                    it.remove();
                    logger.debug((Object)("Removed " + id));
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointReferenceType[] getProperty() {
        EndpointReferenceType[] res = new EndpointReferenceType[this.uuids.size()];
        int i = 0;
        ArrayList<String> arrayList = this.uuids;
        synchronized (arrayList) {
            this.JMS_BASE = WSServerUtilities.makeAddress((String)"JobManagement", (String)"", (ContainerProperties)this.parentWSResource.getKernel().getContainerProperties());
            for (String uuid : this.uuids) {
                res[i] = this.makeEPR(uuid);
            }
        }
        return res;
    }

    protected EndpointReferenceType makeEPR(String id) {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(this.JMS_BASE + id);
        return epr;
    }

    public List<String> getUUIDs() {
        return this.uuids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<String> ids) {
        ArrayList<String> arrayList = this.uuids;
        synchronized (arrayList) {
            this.uuids.addAll(ids);
        }
    }
}

