/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.wsrflite.xmlbeans.impl.SecurityInfoResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.security.Client;
import eu.unicore.security.Xlogin;
import eu.unicore.util.Log;
import java.util.Collections;
import java.util.HashSet;
import org.unigrids.services.atomic.types.SelectedXGroupType;

public class ExtendedSecurityInfoResourceProperty
extends SecurityInfoResourceProperty {
    private static final long serialVersionUID = 1L;

    public ExtendedSecurityInfoResourceProperty(WSResourceImpl parent, boolean addServerCert) {
        super(parent, addServerCert);
    }

    private String[] getGroupsFromTsi(Client client) {
        if (client.getXlogin().getUserName() == null) {
            return new String[0];
        }
        String xnjsReference = ((UASWSResourceImpl)this.parentWSResource).getXNJSReference();
        try {
            Kernel kernel = this.parentWSResource.getKernel();
            return XNJSFacade.get(xnjsReference, kernel).getTSI(client).getGroups();
        }
        catch (Exception ex) {
            Log.logException((String)"Can't get groups from the operating system", (Throwable)ex);
            return new String[0];
        }
    }

    protected void setSelectedGroup() {
        Client client = AuthZAttributeStore.getClient();
        Xlogin xloginO = client.getXlogin();
        boolean useOs = xloginO.isAddDefaultGroups();
        SelectedXGroupType selectedXGroup = SelectedXGroupType.Factory.newInstance();
        selectedXGroup.setUseOSDefaults(useOs);
        HashSet allGroups = new HashSet();
        String[] groupsFromTsi = this.getGroupsFromTsi(client);
        if (xloginO.isGroupSelected()) {
            selectedXGroup.setPrimaryGroup(xloginO.getGroup());
        } else if (groupsFromTsi.length > 0) {
            selectedXGroup.setPrimaryGroup(groupsFromTsi[0]);
        }
        String[] supGroups = xloginO.getSelectedSupplementaryGroups();
        if (supGroups != null && supGroups.length > 0) {
            Collections.addAll(allGroups, supGroups);
            if (useOs) {
                Collections.addAll(allGroups, groupsFromTsi);
            }
        } else if (useOs) {
            Collections.addAll(allGroups, groupsFromTsi);
        }
        allGroups.remove(selectedXGroup.getPrimaryGroup());
        if (allGroups.size() > 0) {
            selectedXGroup.setSupplementaryGroupArray(allGroups.toArray(new String[allGroups.size()]));
        }
        this.getXml()[0].getSecurity().setClientSelectedXgroup(selectedXGroup);
    }
}

