/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.impl.tss.rp.IDBBasedResourceProperty;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.jsdl.JSDLResourceSet;
import de.fzj.unicore.xnjs.resources.BooleanResource;
import de.fzj.unicore.xnjs.resources.DoubleResource;
import de.fzj.unicore.xnjs.resources.IntResource;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.resources.StringResource;
import de.fzj.unicore.xnjs.resources.ValueListResource;
import java.util.ArrayList;
import org.unigrids.services.atomic.types.AvailableResourceDocument;
import org.unigrids.services.atomic.types.AvailableResourceType;
import org.unigrids.services.atomic.types.AvailableResourceTypeType;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;

public class AvailableResourcesRP
extends IDBBasedResourceProperty<ApplicationResourceType[]> {
    private static final long serialVersionUID = 1L;
    private AvailableResourceDocument[] xdoc = new AvailableResourceDocument[0];

    public AvailableResourcesRP(Resource parent, String xnjsReference) {
        super(parent, xnjsReference);
    }

    public AvailableResourceDocument[] getXml() {
        return this.xdoc;
    }

    public AvailableResourcesRP update() {
        if (this.mustUpdate()) {
            Kernel kernel = this.parentWSResource.getKernel();
            IncarnationDataBase idb = XNJSFacade.get(this.xnjsReference, kernel).getIDB();
            ResourceSet rs = idb.getSiteResources();
            ArrayList<AvailableResourceDocument> result = new ArrayList<AvailableResourceDocument>();
            for (de.fzj.unicore.xnjs.resources.Resource r : rs.getResources()) {
                String name = r.getName();
                if (this.isJSDLResource(name) || r.getCategory() == Resource.Category.RANGE_VALUE) continue;
                try {
                    AvailableResourceDocument srd = this.convert(r);
                    result.add(srd);
                }
                catch (Exception e) {
                    logger.error((Object)("Could not process resource : " + r), (Throwable)e);
                }
            }
            this.xdoc = result.toArray(new AvailableResourceDocument[result.size()]);
        }
        return this;
    }

    private boolean isJSDLResource(String name) {
        return JSDLResourceSet.isJSDLResourceName((String)name);
    }

    private AvailableResourceDocument convert(de.fzj.unicore.xnjs.resources.Resource r) {
        AvailableResourceDocument srd = AvailableResourceDocument.Factory.newInstance();
        AvailableResourceType sr = srd.addNewAvailableResource();
        String name = r.getName();
        sr.setName(name);
        AvailableResourceTypeType.Enum type = AvailableResourceTypeType.INT;
        if (r instanceof BooleanResource) {
            type = AvailableResourceTypeType.BOOLEAN;
        } else if (r instanceof ValueListResource) {
            type = AvailableResourceTypeType.CHOICE;
            ValueListResource vlr = (ValueListResource)r;
            sr.setAllowedValueArray(vlr.getValidValues());
        } else if (r instanceof StringResource) {
            type = AvailableResourceTypeType.STRING;
        } else if (r instanceof DoubleResource) {
            type = AvailableResourceTypeType.DOUBLE;
            DoubleResource dr = (DoubleResource)r;
            sr.setMin(String.valueOf(dr.getLower()));
            sr.setMax(String.valueOf(dr.getUpper()));
        } else if (r instanceof IntResource) {
            type = AvailableResourceTypeType.INT;
            IntResource dr = (IntResource)r;
            sr.setMin(String.valueOf(dr.getLower()));
            sr.setMax(String.valueOf(dr.getUpper()));
        }
        sr.setType(type);
        sr.setDescription(r.getDescription());
        if (r.getStringValue() != null) {
            sr.setDefault(r.getStringValue());
        }
        return srd;
    }
}

