/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.impl.tss.rp.IDBBasedResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.MetadataDocument;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceDocument;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;

public class ApplicationsResourceProperty
extends IDBBasedResourceProperty<ApplicationResourceType[]> {
    private static final long serialVersionUID = 20348L;
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", ApplicationsResourceProperty.class);
    private ApplicationResourceType[] apps = new ApplicationResourceType[0];
    private ApplicationResourceDocument[] xdoc = new ApplicationResourceDocument[0];

    public ApplicationsResourceProperty(Resource parent, String xnjsReference) {
        super(parent, xnjsReference);
    }

    public synchronized ApplicationsResourceProperty update() {
        try {
            if (this.mustUpdate()) {
                Kernel kernel = this.parentWSResource.getKernel();
                ApplicationInfo[] xnjsapps = XNJSFacade.get(this.xnjsReference, kernel).getDefinedApplications();
                ApplicationResourceType[] apps = new ApplicationResourceType[xnjsapps.length];
                for (int i = 0; i < apps.length; ++i) {
                    apps[i] = this.convertXNJSApp(xnjsapps[i]);
                }
                logger.debug((Object)("Have " + apps.length + " applications on XNJS"));
                this.setProperty(apps);
            }
            return this;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not update applications resourceproperty, information not available.", (Throwable)e, (Logger)logger);
            return null;
        }
    }

    public ApplicationResourceType[] getProperty() {
        return this.apps;
    }

    public ApplicationResourceDocument[] getXml() {
        return this.xdoc;
    }

    public void setProperty(ApplicationResourceType[] apps) {
        this.xdoc = new ApplicationResourceDocument[apps.length];
        for (int i = 0; i < apps.length; ++i) {
            this.xdoc[i] = ApplicationResourceDocument.Factory.newInstance();
            this.xdoc[i].setApplicationResource(apps[i]);
        }
    }

    public ApplicationResourceType convertXNJSApp(ApplicationInfo xnjsApp) {
        ApplicationResourceType result = ApplicationResourceType.Factory.newInstance();
        result = ApplicationResourceType.Factory.newInstance();
        result.setApplicationName(xnjsApp.getApplicationName());
        result.setApplicationVersion(xnjsApp.getApplicationVersion());
        result.setDescription(xnjsApp.getApplicationDescription());
        eu.unicore.jsdl.extensions.MetadataDocument meta = xnjsApp.getMetadata();
        if (meta != null) {
            MetadataDocument mdd = MetadataDocument.Factory.newInstance();
            mdd.addNewMetadata();
            WSServerUtilities.append((XmlObject)meta, (XmlObject)mdd);
            result.setMetadata(mdd.getMetadata());
        }
        return result;
    }
}

