/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss;

import de.fzj.unicore.uas.Enumeration;
import de.fzj.unicore.uas.JobManagement;
import de.fzj.unicore.uas.ReservationManagement;
import de.fzj.unicore.uas.ResourceReservation;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.TargetSystem;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.impl.ServiceStateResourceProperty;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.UmaskResourceProperty;
import de.fzj.unicore.uas.impl.bp.BPSupportImpl;
import de.fzj.unicore.uas.impl.reservation.ReservationManagementImpl;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageManagementHomeImpl;
import de.fzj.unicore.uas.impl.tss.GenerateJMSInstances;
import de.fzj.unicore.uas.impl.tss.RecreateJMSReferenceList;
import de.fzj.unicore.uas.impl.tss.RecreateReservationReferenceList;
import de.fzj.unicore.uas.impl.tss.TSSAsynchInitialisation;
import de.fzj.unicore.uas.impl.tss.TargetSystemHomeImpl;
import de.fzj.unicore.uas.impl.tss.rp.ApplicationsResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.AvailableResourcesRP;
import de.fzj.unicore.uas.impl.tss.rp.CPUCountResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.CPUTimeResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.ExecutionEnvironmentRP;
import de.fzj.unicore.uas.impl.tss.rp.ExtendedSecurityInfoResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.JobReferenceResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.MemoryPerNodeResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.NameResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.NodesResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.NumberOfJobsProperty;
import de.fzj.unicore.uas.impl.tss.rp.OperatingSystemResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.ProcessorResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.ReservationReferenceResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.SiteSpecificResourcesRP;
import de.fzj.unicore.uas.impl.tss.rp.StorageReferenceResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.TextInfoResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.TotalCPUsResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.UpSinceResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.XLoginResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.ExtendedResourceStatus;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.InvalidModificationException;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.exceptions.UnableToSetTerminationTimeException;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.messaging.ResourceDeletedMessage;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.Utilities;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.unigrids.services.atomic.types.ServiceStatusDocument;
import org.unigrids.services.atomic.types.StorageReferenceType;
import org.unigrids.services.atomic.types.StorageTypeEnumeration;
import org.unigrids.services.atomic.types.UmaskDocument;
import org.unigrids.x2006.x04.services.reservation.ResourceReservationRequestDocument;
import org.unigrids.x2006.x04.services.reservation.ResourceReservationResponseDocument;
import org.unigrids.x2006.x04.services.tss.JobReferenceEnumerationDocument;
import org.unigrids.x2006.x04.services.tss.SubmitDocument;
import org.unigrids.x2006.x04.services.tss.SubmitResponseDocument;
import org.unigrids.x2006.x04.services.tss.SupportsReservationDocument;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TargetSystemImpl
extends UASWSResourceImpl
implements TargetSystem {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", TargetSystemImpl.class);
    public static final String INIT_TSF_ID = TargetSystemImpl.class.getName() + ".tsfid";
    public static final String INIT_TSS_NAME = "TSS_NAME";
    public static final String INIT_XNJS_REFERENCE = "XNJS_REFERENCE";
    @Persist
    private String tsfID;

    @Override
    protected void addWSResourceInterfaces(BPSupportImpl baseProfile) {
        super.addWSResourceInterfaces(baseProfile);
        baseProfile.addWSResourceInterface(TSS_PORT);
        baseProfile.addWSResourceInterface(ResourceReservation.PORTTYPE);
    }

    @Override
    public QName getResourcePropertyDocumentQName() {
        return TargetSystemPropertiesDocument.type.getDocumentElementName();
    }

    @Override
    public void customPostActivate() {
        try {
            logger.trace((Object)("Getting messages from queue " + this.getUniqueID()));
            PullPoint p = this.kernel.getMessaging().getPullPoint(this.getUniqueID());
            JobReferenceResourceProperty jrp = (JobReferenceResourceProperty)((Object)this.properties.get(RPJobReference));
            ReservationReferenceResourceProperty rrp = (ReservationReferenceResourceProperty)((Object)this.properties.get(RPReservationReference));
            while (p.hasNext()) {
                Message message = p.next();
                if (!(message instanceof ResourceDeletedMessage)) continue;
                ResourceDeletedMessage rdm = (ResourceDeletedMessage)message;
                String id = rdm.getDeletedResource();
                String service = rdm.getServiceName();
                if ("JobManagement".equals(service)) {
                    jrp.remove(id);
                    this.setDirty();
                    continue;
                }
                if (!"ReservationManagement".equals(service)) continue;
                rrp.remove(id);
                this.setDirty();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)e.getMessage(), (Throwable)e, (Logger)logger);
        }
        UmaskResourceProperty umaskRP = (UmaskResourceProperty)((Object)this.properties.get(StorageManagement.RPUmask));
        if (umaskRP == null) {
            umaskRP = this.addUmaskRP(Integer.toOctalString(63));
        }
        umaskRP.setListener(new UmaskListenerImpl());
    }

    public SubmitResponseDocument Submit(SubmitDocument in) throws BaseFault {
        if (!((TargetSystemHomeImpl)this.home).isJobSubmissionEnabled()) {
            throw BaseFault.createFault((String)((TargetSystemHomeImpl)this.home).getHighMessage());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("submit: " + in.toString()));
        }
        try {
            JobDefinitionType jsdl = in.getSubmit().getJobDefinition();
            JobDefinitionDocument doc = JobDefinitionDocument.Factory.newInstance();
            doc.setJobDefinition(jsdl);
            HashMap<String, Object> map = new HashMap<String, Object>();
            TerminationTimeDocument.TerminationTime itt = in.getSubmit().getTerminationTime();
            if (itt != null && itt.getCalendarValue() != null) {
                Calendar jobTT = itt.getCalendarValue();
                map.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", jobTT);
                this.checkAndExtendLT(jobTT);
            }
            Action action = XNJSFacade.get(this.xnjsReference, this.kernel).makeAction(doc);
            action.setUmask(this.getUmask());
            if (in.getSubmit().getAutoStartWhenReady()) {
                action.getProcessingContext().put((Object)"EMS_AUTOSUBMIT", (Object)Boolean.TRUE);
            }
            map.put("uas.jobmanagement.action", action);
            map.put("uas.jobmanagement.TSS", this.getUniqueID());
            map.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
            map.put(INIT_PARENT_NODE, this.nodeHelper);
            EndpointReferenceType epr = this.createJob(map);
            SubmitResponseDocument response = SubmitResponseDocument.Factory.newInstance();
            response.addNewSubmitResponse().setJobReference(epr);
            this.setDirty();
            return response;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Error submitting.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)("Error submitting: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void checkAndExtendLT(Calendar newTT) throws UnableToSetTerminationTimeException {
        if (this.getTerminationTime().compareTo(newTT) < 0) {
            logger.debug((Object)"Job termination time exceeds TSS termination time, extending TSS lifetime...");
            Calendar tt = (Calendar)newTT.clone();
            tt.add(5, 1);
            this.setTerminationTime(tt);
        }
    }

    @Override
    public void initialise(String name, Map<String, Object> initobjs) throws Exception {
        super.initialise(name, initobjs);
        this.tsfID = (String)initobjs.get(INIT_TSF_ID);
        this.properties.put(RPNumberOfJobs, new NumberOfJobsProperty((Resource)this, this.xnjsReference));
        String tssName = (String)initobjs.get(INIT_TSS_NAME);
        if (tssName != null) {
            this.properties.put(RPName, new NameResourceProperty((Resource)this, tssName));
        } else {
            this.properties.put(RPName, new NameResourceProperty((Resource)this));
        }
        this.properties.put(RPApplication, this.createApplicationResourceProperty());
        this.properties.put(RPProcessor, this.createProcessorResourceProperty());
        this.properties.put(RPTextInfo, new TextInfoResourceProperty((Resource)this, this.xnjsReference));
        SupportsReservationDocument supportsReservation = SupportsReservationDocument.Factory.newInstance();
        supportsReservation.setSupportsReservation(XNJSFacade.get(this.xnjsReference, this.kernel).supportsReservation());
        this.properties.put(ResourceReservation.RP_SUPPORTS_RESERVATION, new ImmutableResourceProperty((XmlObject)supportsReservation));
        if (!this.uasProperties.getBooleanValue("targetsystem.homeDisable").booleanValue()) {
            this.createHomeStorage();
        }
        this.createAdditionalStorages();
        this.properties.put(RPJobReference, this.createJobReferenceProperty());
        this.properties.put(RPReservationReference, this.createReservationReferenceProperty());
        this.properties.put(RPOperatingSystem, this.createOSResourceProperty());
        this.properties.put(RPCPUTime, new CPUTimeResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPNodeCount, new NodesResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPMemoryPerNode, new MemoryPerNodeResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPCPUCount, new CPUCountResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPTotalCPUCount, new TotalCPUsResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPUpSince, new UpSinceResourceProperty());
        this.properties.put(RPSiteSpecificResources, new SiteSpecificResourcesRP((Resource)this, this.xnjsReference));
        this.properties.put(RPAvailableResources, new AvailableResourcesRP((Resource)this, this.xnjsReference));
        this.properties.put(RPExecutionEnvironments, new ExecutionEnvironmentRP((Resource)this, this.xnjsReference));
        this.properties.put(ServiceStatusDocument.type.getDocumentElementName(), new ServiceStateResourceProperty(this));
        this.properties.put(RPXlogin, new XLoginResourceProperty((ResourceImpl)this));
        this.addUmaskRP(Integer.toOctalString(63));
        try {
            JobReferenceEnumerationDocument jred = JobReferenceEnumerationDocument.Factory.newInstance();
            jred.setJobReferenceEnumeration(this.createJobListEnumeration());
            this.properties.put(RPJobReferenceEnumeration, new ImmutableResourceProperty((XmlObject)jred));
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Error creating job reference enumeration", (Throwable)ex, (Logger)logger);
        }
        Boolean publishFlag = (Boolean)initobjs.get(INITPARAM_PUBLISH_TO_REGISTRY);
        if (Boolean.TRUE.equals(publishFlag)) {
            logger.info((Object)("Publishing TargetSystem <" + this.getUniqueID() + "> to registry."));
            this.publish();
        }
        this.setResourceStatus(ExtendedResourceStatus.ResourceStatus.INITIALIZING);
        this.setStatusMessage("OK");
        Client c = this.getClient();
        RecreateJMSReferenceList rj = new RecreateJMSReferenceList(this.kernel, this.getUniqueID(), c);
        GenerateJMSInstances rx = new GenerateJMSInstances(this.kernel, this.getUniqueID(), c, this.xnjsReference);
        RecreateReservationReferenceList rr = new RecreateReservationReferenceList(this.kernel, this.getUniqueID(), c);
        this.kernel.getContainerProperties().getThreadingServices().getScheduledExecutorService().schedule((Runnable)((Object)new TSSAsynchInitialisation(this.kernel, this.getUniqueID(), rj, rx, rr)), 200L, TimeUnit.MILLISECONDS);
    }

    protected ResourceProperty<?> getSecurityInfoResourceProperty(boolean addServerCert) {
        return new ExtendedSecurityInfoResourceProperty(this, addServerCert);
    }

    protected UmaskResourceProperty addUmaskRP(String umask) {
        UmaskResourceProperty umaskRP = new UmaskResourceProperty(this, umask);
        umaskRP.setListener(new UmaskListenerImpl());
        this.properties.put(StorageManagement.RPUmask, umaskRP);
        return umaskRP;
    }

    protected void createHomeStorage() {
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        String uuid = this.createStorageID("Home");
        initMap.put(SMSBaseImpl.INIT_UNIQUE_ID, uuid);
        StorageDescription storageDescription = new StorageDescription("HomeOf-" + this.getUniqueID(), "Home", null, StorageManagementHomeImpl.StorageTypes.HOME, null, null, false, false, false, null, "Home storage", null);
        initMap.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, storageDescription);
        Calendar tt = Calendar.getInstance();
        tt.add(1, 10);
        initMap.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", tt);
        initMap.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
        initMap.put(SMSBaseImpl.INIT_PARENT_NODE, this.nodeHelper);
        EndpointReferenceType homeEPR = this.createStorageManagement("HOME", initMap);
        if (homeEPR == null) {
            return;
        }
        StorageReferenceType srt = StorageReferenceType.Factory.newInstance();
        srt.setStorageEndpointReference(homeEPR);
        srt.setType(StorageTypeEnumeration.HOME);
        this.getOrCreateStorageReferenceResourceProperty().add(srt);
    }

    protected String createStorageID(String smsName) {
        try {
            if (!this.uasProperties.getBooleanValue("targetsystem.uniqueStorageIds").booleanValue()) {
                String xlogin = this.getClient().getXlogin().getUserName();
                return xlogin + "-" + smsName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Utilities.newUniqueID();
    }

    protected void createAdditionalStorages() {
        Collection<StorageDescription> storages = this.uasProperties.getAddonStorages();
        for (StorageDescription a : storages) {
            this.createStorageResource(a);
            logger.debug((Object)("Added " + a));
        }
    }

    protected void createStorageResource(StorageDescription desc) {
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        String uuid = this.createStorageID(desc.getName());
        initMap.put(SMSBaseImpl.INIT_UNIQUE_ID, uuid);
        initMap.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, desc);
        initMap.put(SMSBaseImpl.INIT_PARENT_NODE, this.nodeHelper);
        Calendar tt = Calendar.getInstance();
        tt.add(1, 10);
        initMap.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", tt);
        initMap.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
        EndpointReferenceType smsEpr = this.createStorageManagement(desc.getStorageTypeAsString(), initMap);
        if (smsEpr == null) {
            return;
        }
        StorageReferenceResourceProperty srp = this.getOrCreateStorageReferenceResourceProperty();
        srp.add(smsEpr);
    }

    protected EndpointReferenceType createJob(Map<String, Object> initParam) throws Exception {
        Home jmsHome = this.kernel.getHome("JobManagement");
        String id = jmsHome.createWSRFServiceInstance(initParam);
        EndpointReferenceType epr = WSServerUtilities.makeEPR((String)"JobManagement", (String)id, (QName)JobManagement.JMS_PORT, (Kernel)this.kernel);
        try {
            JobReferenceResourceProperty j = (JobReferenceResourceProperty)((Object)this.properties.get(RPJobReference));
            j.add(epr);
        }
        catch (Exception e) {
            logger.error((Object)"Could not store job reference.", (Throwable)e);
        }
        return epr;
    }

    protected EndpointReferenceType createStorageManagement(String type, Map<String, Object> initParam) {
        try {
            Home home = this.kernel.getHome("StorageManagement");
            if (home == null) {
                logger.warn((Object)"Storage management service is not deployed.");
                return null;
            }
            String id = (String)initParam.get(INIT_UNIQUE_ID);
            boolean mustCreate = true;
            if (id != null) {
                try {
                    String smsOwner;
                    SMSBaseImpl sms = (SMSBaseImpl)home.get(id);
                    String string = smsOwner = sms.getOwner() != null ? sms.getOwner().getName() : null;
                    if (smsOwner != null && !this.kernel.getSecurityManager().isAccessible(this.getClient(), sms.getServiceName(), id, smsOwner, sms.getVOMembership())) {
                        mustCreate = true;
                        logger.info((Object)("Existing storage <" + id + "> is not accessible to current user (certificate change?), re-creating it."));
                    } else {
                        mustCreate = false;
                    }
                }
                catch (ResourceUnknownException ignored) {
                    mustCreate = true;
                }
            }
            if (mustCreate) {
                id = home.createWSRFServiceInstance(initParam);
            }
            return WSServerUtilities.makeEPR((String)"StorageManagement", (String)id, (QName)StorageManagement.SMS_PORT, (Kernel)this.kernel);
        }
        catch (ResourceNotCreatedException rnc) {
            String msg = Log.createFaultMessage((String)("Storage of type <" + type + "> was NOT created."), (Throwable)rnc);
            logger.info((Object)msg);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not create storage management service.", (Throwable)e, (Logger)logger);
        }
        return null;
    }

    protected ApplicationsResourceProperty createApplicationResourceProperty() {
        return new ApplicationsResourceProperty((Resource)this, this.xnjsReference);
    }

    protected ProcessorResourceProperty createProcessorResourceProperty() {
        return new ProcessorResourceProperty((Resource)this, this.xnjsReference);
    }

    protected StorageReferenceResourceProperty createStorageReferenceResourceProperty(EndpointReferenceType epr, StorageTypeEnumeration.Enum storageType) {
        StorageReferenceType type = StorageReferenceType.Factory.newInstance();
        type.setStorageEndpointReference(epr);
        type.setType(storageType);
        StorageReferenceResourceProperty srp = new StorageReferenceResourceProperty(new StorageReferenceType[]{type});
        return srp;
    }

    protected StorageReferenceResourceProperty getOrCreateStorageReferenceResourceProperty() {
        StorageReferenceResourceProperty srp = (StorageReferenceResourceProperty)((Object)this.properties.get(RPStorageReference));
        if (srp == null) {
            srp = new StorageReferenceResourceProperty(new StorageReferenceType[0]);
            this.properties.put(RPStorageReference, srp);
        }
        return srp;
    }

    protected void addStorageReference(EndpointReferenceType epr, StorageTypeEnumeration.Enum storageType) {
        StorageReferenceResourceProperty srp = this.getOrCreateStorageReferenceResourceProperty();
        StorageReferenceType type = StorageReferenceType.Factory.newInstance();
        type.setStorageEndpointReference(epr);
        type.setType(storageType);
        srp.add(type);
    }

    protected JobReferenceResourceProperty createJobReferenceProperty() {
        JobReferenceResourceProperty rp = new JobReferenceResourceProperty((Resource)this);
        return rp;
    }

    protected ReservationReferenceResourceProperty createReservationReferenceProperty() {
        return new ReservationReferenceResourceProperty(new EndpointReferenceType[0]);
    }

    protected ResourceProperty<?> createOSResourceProperty() {
        return new OperatingSystemResourceProperty((Resource)this, this.xnjsReference);
    }

    public QName getPortType() {
        return TSS_PORT;
    }

    public void destroy() {
        try {
            ResourceDeletedMessage m = new ResourceDeletedMessage((Serializable)((Object)("deleted:" + this.getUniqueID())));
            m.setDeletedResource(this.getUniqueID());
            m.setServiceName(this.getServiceName());
            this.kernel.getMessaging().getChannel(this.tsfID).publish((Message)m);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not send internal message.", (Throwable)e, (Logger)logger);
        }
        if (this.uasProperties.getBooleanValue("targetsystem.uniqueStorageIds").booleanValue()) {
            try {
                StorageReferenceResourceProperty storages = (StorageReferenceResourceProperty)((Object)this.properties.get(RPStorageReference));
                if (storages != null) {
                    StorageReferenceType[] smsList;
                    for (StorageReferenceType sms : smsList = storages.getProperty()) {
                        EndpointReferenceType epr = sms.getStorageEndpointReference();
                        BaseUASClient c = new BaseUASClient(epr, (IClientConfiguration)this.kernel.getClientConfiguration());
                        c.destroy();
                    }
                }
            }
            catch (Exception e) {
                LogUtil.logException((String)("Could not destroy storages for TSS <" + this.getUniqueID() + ">"), (Throwable)e, (Logger)logger);
            }
        }
        try {
            ImmutableResourceProperty p = (ImmutableResourceProperty)this.properties.get(RPJobReferenceEnumeration);
            JobReferenceEnumerationDocument jred = JobReferenceEnumerationDocument.Factory.parse((InputStream)p.getXml()[0].newInputStream());
            BaseUASClient c = new BaseUASClient(jred.getJobReferenceEnumeration(), (IClientConfiguration)this.kernel.getClientConfiguration());
            c.destroy();
        }
        catch (Exception e) {
            LogUtil.logException((String)("Could not destroy enumeration for TSS <" + this.getUniqueID() + ">"), (Throwable)e, (Logger)logger);
        }
        try {
            if (this.xnjsReference != null) {
                XNJSFacade.get(this.xnjsReference, this.kernel).shutdown();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not shutdown the XNJS instance.", (Throwable)e, (Logger)logger);
        }
        super.destroy();
        String ownerName = this.getOwner() != null ? this.getOwner().toString() : "<no client>";
        logger.info((Object)("Removed TargetSystem resource <" + this.getUniqueID() + "> owned by " + ownerName));
    }

    public ResourceReservationResponseDocument ReserveResources(ResourceReservationRequestDocument in) throws BaseFault {
        try {
            ResourcesDocument rd = ResourcesDocument.Factory.newInstance();
            rd.setResources(in.getResourceReservationRequest().getResources());
            Calendar startTime = in.getResourceReservationRequest().getStartTime();
            EndpointReferenceType epr = this.createReservationResource(rd, startTime);
            ResourceReservationResponseDocument res = ResourceReservationResponseDocument.Factory.newInstance();
            res.addNewResourceReservationResponse().setReservationReference(epr);
            try {
                ReservationReferenceResourceProperty j = (ReservationReferenceResourceProperty)((Object)this.properties.get(RPReservationReference));
                j.add(epr);
            }
            catch (Exception e) {
                LogUtil.logException((String)"Could not store reservation reference.", (Throwable)e, (Logger)logger);
            }
            this.setDirty();
            return res;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Reservation not created.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)("Reservation not created. Reason: " + e.getMessage()));
        }
    }

    protected EndpointReferenceType createReservationResource(ResourcesDocument resources, Calendar startTime) throws Exception {
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        initMap.put(INITPARAM_XNJS_REFERENCE, this.xnjsReference);
        initMap.put(ReservationManagementImpl.INITPARAM_TSS_REFERENCE, this.getEPR());
        initMap.put(ReservationManagementImpl.INITPARAM_RESOURCES, resources);
        initMap.put(ReservationManagementImpl.INITPARAM_STARTTIME, startTime);
        initMap.put(INIT_PARENT_NODE, this.getNode());
        String id = this.kernel.getHome("ReservationManagement").createWSRFServiceInstance(initMap);
        return WSServerUtilities.makeEPR((String)"ReservationManagement", (String)id, (QName)ReservationManagement.PORT, (Kernel)this.kernel);
    }

    protected EndpointReferenceType createJobListEnumeration() throws Exception {
        HashMap<String, Object> init = new HashMap<String, Object>();
        init.put("targetServiceEPR", this.getEPR());
        init.put("targetPropertyQName", RPJobReference);
        Calendar c = Calendar.getInstance();
        c.add(2, 24);
        init.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", c);
        Home h = this.kernel.getHome("Enumeration");
        if (h == null) {
            throw new Exception("Enumeration service is not deployed!");
        }
        String id = h.createWSRFServiceInstance(init);
        return WSServerUtilities.makeEPR((String)"Enumeration", (String)id, (QName)Enumeration.ENUM_PORT, (Kernel)this.kernel);
    }

    public String getUmask() {
        UmaskResourceProperty rp = (UmaskResourceProperty)((Object)this.properties.get(StorageManagement.RPUmask));
        if (rp == null) {
            return Integer.toOctalString(63);
        }
        return ((UmaskDocument[])rp.getXml())[0].getUmask();
    }

    private class UmaskListenerImpl
    implements UmaskResourceProperty.UmaskChangedListener {
        private UmaskListenerImpl() {
        }

        @Override
        public void umaskChanged(String newUmask) throws InvalidModificationException {
            try {
                Client client = TargetSystemImpl.this.getClient();
                TSI ret = XNJSFacade.get(TargetSystemImpl.this.xnjsReference, TargetSystemImpl.this.kernel).getConfiguration().getTargetSystemInterface(client);
                ret.setUmask(newUmask);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidModificationException(e.getMessage());
            }
        }
    }
}

