/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss;

import de.fzj.unicore.uas.ResourceReservation;
import de.fzj.unicore.uas.TargetSystem;
import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.bp.BPSupportImpl;
import de.fzj.unicore.uas.impl.tss.TargetSystemImpl;
import de.fzj.unicore.uas.impl.tss.rp.AccessibleTSSReferenceRP;
import de.fzj.unicore.uas.impl.tss.rp.ApplicationsResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.AvailableResourcesRP;
import de.fzj.unicore.uas.impl.tss.rp.CPUCountResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.CPUTimeResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.ExecutionEnvironmentRP;
import de.fzj.unicore.uas.impl.tss.rp.ExtendedSecurityInfoResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.MemoryPerNodeResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.NodesResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.OperatingSystemResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.PerformanceDataResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.ProcessorResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.SiteSpecificResourcesRP;
import de.fzj.unicore.uas.impl.tss.rp.TSSReferenceResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.TotalCPUsResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.UpSinceResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.XLoginResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rl2.DestroyDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeResponseDocument;
import org.unigrids.x2006.x04.services.tsf.CreateTSRDocument;
import org.unigrids.x2006.x04.services.tsf.CreateTSRResponseDocument;
import org.unigrids.x2006.x04.services.tsf.NameDocument;
import org.unigrids.x2006.x04.services.tsf.TargetSystemFactoryPropertiesDocument;
import org.unigrids.x2006.x04.services.tss.SupportsReservationDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TargetSystemFactoryImpl
extends UASWSResourceImpl
implements TargetSystemFactory {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services", TargetSystemFactoryImpl.class);
    public static final String INIT_TSF_NAME = "TSF_NAME";
    @Persist
    private Map<String, String> tssOwners = new HashMap<String, String>();

    @Override
    protected void addWSResourceInterfaces(BPSupportImpl baseProfile) {
        super.addWSResourceInterfaces(baseProfile);
        baseProfile.addWSResourceInterface(TSF_PORT);
    }

    public String getOwnerForTSS(String tssID) {
        return this.tssOwners.get(tssID);
    }

    public CreateTSRResponseDocument CreateTSR(CreateTSRDocument in) throws BaseFault {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TargetSystemImpl.INIT_TSF_ID, this.getUniqueID());
            Calendar initialTT = null;
            try {
                initialTT = in.getCreateTSR().getTerminationTime().getCalendarValue();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (initialTT != null) {
                map.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", initialTT);
            }
            map.put(INIT_PARENT_NODE, this.nodeHelper);
            EndpointReferenceType epr = this.createTargetSystem(map);
            String tssID = WSServerUtilities.extractResourceID((EndpointReferenceType)epr);
            String clientName = this.getClient() != null ? this.getClient().getDistinguishedName() : "<no client>";
            logger.info((Object)("Created new TargetSystem resource <" + tssID + "> for " + clientName));
            this.tssOwners.put(tssID, clientName);
            TSSReferenceResourceProperty ref = this.getTSSReferenceProperty();
            ref.add(epr);
            CreateTSRResponseDocument response = CreateTSRResponseDocument.Factory.newInstance();
            response.addNewCreateTSRResponse();
            response.getCreateTSRResponse().setTsrReference(epr);
            this.setDirty();
            return response;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Did not create new TargetSystem resource.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)e.getMessage());
        }
    }

    @Override
    public void initialise(String serviceName, Map<String, Object> initArgs) throws Exception {
        super.initialise(serviceName, initArgs);
        this.properties.put(RPApplicationResource, this.createApplicationResourceProperty());
        this.properties.put(RPTSSReferences, new TSSReferenceResourceProperty(new EndpointReferenceType[0]));
        this.properties.put(RPAccessibleTSSReferences, new AccessibleTSSReferenceRP(this));
        this.properties.put(RPCPUTime, new CPUTimeResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPNodeCount, new NodesResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPMemoryPerNode, new MemoryPerNodeResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPCPUCount, new CPUCountResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPTotalCPUCount, new TotalCPUsResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPProcessor, new ProcessorResourceProperty((Resource)this, this.xnjsReference));
        this.properties.put(RPUpSince, new UpSinceResourceProperty());
        this.properties.put(RPXlogin, new XLoginResourceProperty((ResourceImpl)this));
        String tsfName = (String)initArgs.get(INIT_TSF_NAME);
        NameDocument nd = NameDocument.Factory.newInstance();
        nd.setName(tsfName);
        this.properties.put(RPName, new ImmutableResourceProperty((XmlObject)nd));
        SupportsReservationDocument supportsReservation = SupportsReservationDocument.Factory.newInstance();
        supportsReservation.setSupportsReservation(XNJSFacade.get(this.xnjsReference, this.kernel).supportsReservation());
        this.properties.put(ResourceReservation.RP_SUPPORTS_RESERVATION, new ImmutableResourceProperty((XmlObject)supportsReservation));
        this.properties.put(RPSiteSpecificResources, new SiteSpecificResourcesRP((Resource)this, this.xnjsReference));
        this.properties.put(RPAvailableResources, new AvailableResourcesRP((Resource)this, this.xnjsReference));
        this.properties.put(RPExecutionEnvironments, new ExecutionEnvironmentRP((Resource)this, this.xnjsReference));
        this.properties.put(RPOperatingSystem, this.createOSResourceProperty());
        this.properties.put(RPPerformanceData, new PerformanceDataResourceProperty((Resource)this, this.xnjsReference));
        this.publish();
    }

    protected ResourceProperty<?> getSecurityInfoResourceProperty(boolean addServerCert) {
        return new ExtendedSecurityInfoResourceProperty(this, addServerCert);
    }

    public DestroyResponseDocument Destroy(DestroyDocument in) throws ResourceNotDestroyedFault, ResourceUnknownFault, ResourceUnavailableFault {
        throw ResourceNotDestroyedFault.createFault((String)"Not destroyed.");
    }

    public SetTerminationTimeResponseDocument SetTerminationTime(SetTerminationTimeDocument in) throws UnableToSetTerminationTimeFault, TerminationTimeChangeRejectedFault, ResourceUnknownFault, ResourceUnavailableFault {
        throw TerminationTimeChangeRejectedFault.createFault((String)"Not changed.");
    }

    protected EndpointReferenceType createTargetSystem(Map<String, Object> initParam) throws Exception {
        String id = this.kernel.getHome("TargetSystemService").createWSRFServiceInstance(initParam);
        return WSServerUtilities.makeEPR((String)"TargetSystemService", (String)id, (QName)TargetSystem.PORTTYPE, (Kernel)this.kernel);
    }

    protected EndpointReferenceType createTargetSystem(Map<String, Object> initParam, InputStream xnjsConfig) throws Exception {
        String xnjsRef = this.getUniqueID();
        XNJSFacade f = XNJSFacade.get(xnjsRef, this.kernel);
        f.configure(xnjsConfig);
        initParam.put(INITPARAM_XNJS_REFERENCE, xnjsRef);
        String id = this.kernel.getHome("TargetSystemService").createWSRFServiceInstance(initParam);
        return WSServerUtilities.makeEPR((String)"TargetSystemService", (String)id, (QName)TargetSystem.TSS_PORT, (Kernel)this.kernel);
    }

    public TSSReferenceResourceProperty getTSSReferenceProperty() {
        return (TSSReferenceResourceProperty)((Object)this.properties.get(RPTSSReferences));
    }

    @Override
    public QName getResourcePropertyDocumentQName() {
        return TargetSystemFactoryPropertiesDocument.type.getDocumentElementName();
    }

    protected ResourceProperty<?> createOSResourceProperty() {
        return new OperatingSystemResourceProperty((Resource)this, this.xnjsReference);
    }

    protected ApplicationsResourceProperty createApplicationResourceProperty() {
        return new ApplicationsResourceProperty((Resource)this, this.xnjsReference);
    }

    @Override
    public void customPostActivate() {
        try {
            PullPoint p = this.kernel.getMessaging().getPullPoint(this.getUniqueID());
            TSSReferenceResourceProperty tssRef = this.getTSSReferenceProperty();
            while (p.hasNext()) {
                String m = (String)((Object)p.next().getBody());
                if (!m.startsWith("deleted:")) continue;
                String id = m.substring(m.indexOf(":") + 1);
                logger.debug((Object)("Removing TSS with ID " + id + "..."));
                tssRef.remove(id);
                this.tssOwners.remove(id);
                this.setDirty();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)e.getMessage(), (Throwable)e, (Logger)logger);
        }
    }

    public QName getPortType() {
        return TSF_PORT;
    }
}

