/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.impl.tss;

import de.fzj.unicore.uas.impl.tss.TargetSystemImpl;
import de.fzj.unicore.wsrflite.ExtendedResourceStatus;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.events.AsynchActionWithCallback;
import eu.unicore.util.Log;

public class TSSAsynchInitialisation
extends AsynchActionWithCallback<TargetSystemImpl> {
    public TSSAsynchInitialisation(Kernel kernel, String resourceID, final Runnable ... tasks) {
        super(new Runnable(){

            @Override
            public void run() {
                for (Runnable r : tasks) {
                    r.run();
                }
            }
        }, kernel.getHome("TargetSystemService"), resourceID);
    }

    public void taskFinished(TargetSystemImpl resource) {
        resource.setResourceStatus(ExtendedResourceStatus.ResourceStatus.READY);
        log.info((Object)("Finished init/update of TSS " + resource.getUniqueID()));
    }

    public void taskFailed(TargetSystemImpl resource, RuntimeException ex) {
        String msg = Log.createFaultMessage((String)("Failed init/update of TSS " + resource.getUniqueID()), (Throwable)ex);
        resource.setResourceStatus(ExtendedResourceStatus.ResourceStatus.ERROR);
        resource.setStatusMessage(msg);
        log.error((Object)("Failed init/update of TSS " + resource.getUniqueID()), (Throwable)ex);
    }
}

